/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GregorianCalendarSerializer
extends Serializer<GregorianCalendar> {
    private final Field _zoneField;

    public GregorianCalendarSerializer() {
        try {
            this._zoneField = Calendar.class.getDeclaredField("zone");
            this._zoneField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GregorianCalendar read(Kryo kryo, Input input, Class<? extends GregorianCalendar> type2) {
        Calendar result2 = GregorianCalendar.getInstance();
        result2.setTimeInMillis(input.readLong(true));
        result2.setLenient(input.readBoolean());
        result2.setFirstDayOfWeek(input.readInt(true));
        result2.setMinimalDaysInFirstWeek(input.readInt(true));
        String timeZoneId = input.readString();
        if (!this.getTimeZone(result2).getID().equals(timeZoneId)) {
            result2.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        }
        return (GregorianCalendar)result2;
    }

    @Override
    public void write(Kryo kryo, Output output, GregorianCalendar calendar) {
        output.writeLong(calendar.getTimeInMillis(), true);
        output.writeBoolean(calendar.isLenient());
        output.writeInt(calendar.getFirstDayOfWeek(), true);
        output.writeInt(calendar.getMinimalDaysInFirstWeek(), true);
        output.writeString(this.getTimeZone(calendar).getID());
    }

    @Override
    public GregorianCalendar copy(Kryo kryo, GregorianCalendar original) {
        return (GregorianCalendar)original.clone();
    }

    private TimeZone getTimeZone(Calendar obj) {
        try {
            return (TimeZone)this._zoneField.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

