/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.reflect.ReflectionFactory;

public class KryoReflectionFactorySupport
extends Kryo {
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    private static final Object[] INITARGS = new Object[0];
    private static final Map<Class<?>, Constructor<?>> _constructors = new ConcurrentHashMap();

    @Override
    public Serializer<?> getDefaultSerializer(Class type2) {
        Serializer result2 = super.getDefaultSerializer(type2);
        if (result2 instanceof FieldSerializer && ((FieldSerializer)result2).getFieldSerializerConfig().getIgnoreSyntheticFields()) {
            FieldSerializer fieldSerializer = (FieldSerializer)result2;
            fieldSerializer.getFieldSerializerConfig().setIgnoreSyntheticFields(false);
            fieldSerializer.updateFields();
        }
        return result2;
    }

    @Override
    public <T> T newInstance(Class<T> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Constructor<?> constructor = _constructors.get(type2);
        if (constructor == null) {
            constructor = KryoReflectionFactorySupport.getNoArgsConstructor(type2);
            if (constructor == null) {
                constructor = KryoReflectionFactorySupport.newConstructorForSerialization(type2);
            }
            _constructors.put(type2, constructor);
        }
        return (T)KryoReflectionFactorySupport.newInstanceFrom(constructor);
    }

    private static Object newInstanceFrom(Constructor<?> constructor) {
        try {
            return constructor.newInstance(INITARGS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstanceFromReflectionFactory(Class<T> type2) {
        Constructor<?> constructor = _constructors.get(type2);
        if (constructor == null) {
            constructor = KryoReflectionFactorySupport.newConstructorForSerialization(type2);
            _constructors.put(type2, constructor);
        }
        return (T)KryoReflectionFactorySupport.newInstanceFrom(constructor);
    }

    private static <T> Constructor<?> newConstructorForSerialization(Class<T> type2) {
        try {
            Constructor<?> constructor = REFLECTION_FACTORY.newConstructorForSerialization(type2, Object.class.getDeclaredConstructor(new Class[0]));
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor<?> getNoArgsConstructor(Class<?> type2) {
        Constructor<?>[] constructors2;
        for (Constructor<?> constructor : constructors2 = type2.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        return null;
    }
}

