/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.ImmutableList;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.TableSerializerBase;
import java.util.List;

public class ArrayTableSerializer<R, C, V>
extends TableSerializerBase<R, C, V, ArrayTable<R, C, V>> {
    private static final boolean HANDLES_NULL = false;
    private static final boolean IMMUTABLE = false;

    public ArrayTableSerializer() {
        super(false, false);
    }

    @Override
    public void write(Kryo kryo, Output output, ArrayTable<R, C, V> table) {
        ImmutableList rowKeys = table.rowKeyList();
        ImmutableList columnKeys = table.columnKeyList();
        kryo.writeClassAndObject(output, rowKeys);
        kryo.writeClassAndObject(output, columnKeys);
        for (Object rowKey : rowKeys) {
            for (Object columnKey : columnKeys) {
                Object val = table.get(rowKey, columnKey);
                kryo.writeClassAndObject(output, val);
            }
        }
    }

    @Override
    public ArrayTable<R, C, V> read(Kryo kryo, Input input, Class<? extends ArrayTable<R, C, V>> type2) {
        List rowKeys = (List)kryo.readClassAndObject(input);
        List columnKeys = (List)kryo.readClassAndObject(input);
        ArrayTable table = ArrayTable.create((Iterable)rowKeys, (Iterable)columnKeys);
        for (Object rowKey : rowKeys) {
            for (Object columnKey : columnKeys) {
                Object val = kryo.readClassAndObject(input);
                table.put(rowKey, columnKey, val);
            }
        }
        return table;
    }

    @Override
    public ArrayTable<R, C, V> copy(Kryo kryo, ArrayTable<R, C, V> original) {
        return ArrayTable.create(original);
    }

    private static Serializer<?> getSerializer(Kryo kryo, Class<?> type2) {
        Registration registration = kryo.getClassResolver().getRegistration(type2);
        return registration != null ? registration.getSerializer() : null;
    }

    public static void registerSerializers(Kryo kryo) {
        Serializer<ImmutableList> immutableListSerializer = ArrayTableSerializer.getSerializer(kryo, ImmutableList.class);
        if (!(immutableListSerializer instanceof ImmutableListSerializer)) {
            ImmutableListSerializer.registerSerializers(kryo);
        }
        ArrayTableSerializer serializer = new ArrayTableSerializer();
        kryo.register(ArrayTable.class, serializer);
    }
}

