/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;

public class ImmutableListSerializer
extends Serializer<ImmutableList<Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableListSerializer() {
        super(false, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableList<Object> object) {
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    @Override
    public ImmutableList<Object> read(Kryo kryo, Input input, Class<? extends ImmutableList<Object>> type2) {
        int size = input.readInt(true);
        Object[] list = new Object[size];
        for (int i = 0; i < size; ++i) {
            list[i] = kryo.readClassAndObject(input);
        }
        return ImmutableList.copyOf((Object[])list);
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableListSerializer serializer = new ImmutableListSerializer();
        kryo.register(ImmutableList.class, serializer);
        kryo.register(ImmutableList.of().getClass(), serializer);
        kryo.register(ImmutableList.of((Object)1).getClass(), serializer);
        kryo.register(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4).subList(1, 3).getClass(), serializer);
        kryo.register(ImmutableList.of((Object)1, (Object)2).reverse().getClass(), serializer);
        kryo.register(Lists.charactersOf((String)"KryoRocks").getClass(), serializer);
        HashBasedTable baseTable = HashBasedTable.create();
        baseTable.put((Object)1, (Object)2, (Object)3);
        baseTable.put((Object)4, (Object)5, (Object)6);
        ImmutableTable table = ImmutableTable.copyOf((Table)baseTable);
        kryo.register(table.values().getClass(), serializer);
    }
}

