/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class ReverseListSerializer
extends Serializer<List<Object>> {
    private static final CollectionSerializer serializer = new CollectionSerializer();

    @Override
    public void write(Kryo kryo, Output output, List<Object> object) {
        List forwardList = Lists.reverse(object);
        serializer.write(kryo, output, forwardList);
    }

    @Override
    public List<Object> copy(Kryo kryo, List<Object> original) {
        List forwardList = Lists.reverse(original);
        return Lists.reverse((List)serializer.copy(kryo, forwardList));
    }

    public static void registerSerializers(Kryo kryo) {
        kryo.register(Lists.reverse((List)Lists.newLinkedList()).getClass(), ReverseListSerializer.forReverseList());
        kryo.register(Lists.reverse((List)Lists.newArrayList()).getClass(), ReverseListSerializer.forRandomAccessReverseList());
    }

    public static ReverseListSerializer forReverseList() {
        return new ReverseList();
    }

    public static ReverseListSerializer forRandomAccessReverseList() {
        return new RandomAccessReverseList();
    }

    private static class RandomAccessReverseList
    extends ReverseListSerializer {
        private RandomAccessReverseList() {
        }

        @Override
        public List<Object> read(Kryo kryo, Input input, Class<? extends List<Object>> type2) {
            List forwardList = (List)serializer.read(kryo, input, ArrayList.class);
            return Lists.reverse((List)forwardList);
        }
    }

    private static class ReverseList
    extends ReverseListSerializer {
        private ReverseList() {
        }

        @Override
        public List<Object> read(Kryo kryo, Input input, Class<? extends List<Object>> type2) {
            List forwardList = (List)serializer.read(kryo, input, LinkedList.class);
            return Lists.reverse((List)forwardList);
        }
    }
}

