/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.jodatime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import de.javakaffee.kryoserializers.jodatime.IdentifiableChronology;
import org.joda.time.Chronology;
import org.joda.time.LocalDate;

public class JodaLocalDateSerializer
extends Serializer<LocalDate> {
    public JodaLocalDateSerializer() {
        this.setImmutable(true);
    }

    @Override
    public LocalDate read(Kryo kryo, Input input, Class<? extends LocalDate> type2) {
        int packedYearMonthDay = input.readInt(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        return new LocalDate(packedYearMonthDay / 416, packedYearMonthDay % 416 / 32, packedYearMonthDay % 32, chronology);
    }

    @Override
    public void write(Kryo kryo, Output output, LocalDate localDate) {
        int packedYearMonthDay = localDate.getYear() * 13 * 32 + localDate.getMonthOfYear() * 32 + localDate.getDayOfMonth();
        output.writeInt(packedYearMonthDay, true);
        String chronologyId = IdentifiableChronology.getChronologyId(localDate.getChronology());
        output.writeString(chronologyId == null ? "" : chronologyId);
    }
}

