/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct;

import io.kaitai.struct.KaitaiStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ByteBufferKaitaiStream
extends KaitaiStream {
    private FileChannel fc;
    private ByteBuffer bb;

    public ByteBufferKaitaiStream(String fileName) throws IOException {
        this.fc = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.READ);
        this.bb = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size());
    }

    public ByteBufferKaitaiStream(byte[] arr) {
        this.fc = null;
        this.bb = ByteBuffer.wrap(arr);
    }

    public ByteBufferKaitaiStream(ByteBuffer buffer) {
        this.fc = null;
        this.bb = buffer;
    }

    public ByteBuffer asRoBuffer() {
        ByteBuffer retVal = this.bb.asReadOnlyBuffer();
        retVal.rewind();
        return retVal;
    }

    @Override
    public void close() throws IOException {
        if (this.fc != null) {
            this.fc.close();
            this.fc = null;
        }
        this.bb = null;
    }

    @Override
    public boolean isEof() {
        return !this.bb.hasRemaining() && this.bitsLeft <= 0;
    }

    @Override
    public void seek(int newPos) {
        this.bb.position(newPos);
    }

    @Override
    public void seek(long newPos) {
        if (newPos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java ByteBuffer can't be seeked past Integer.MAX_VALUE");
        }
        this.bb.position((int)newPos);
    }

    @Override
    public int pos() {
        return this.bb.position();
    }

    @Override
    public long size() {
        return this.bb.limit();
    }

    @Override
    public byte readS1() {
        return this.bb.get();
    }

    @Override
    public short readS2be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getShort();
    }

    @Override
    public int readS4be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getInt();
    }

    @Override
    public long readS8be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getLong();
    }

    @Override
    public short readS2le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getShort();
    }

    @Override
    public int readS4le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getInt();
    }

    @Override
    public long readS8le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getLong();
    }

    @Override
    public int readU1() {
        return this.bb.get() & 0xFF;
    }

    @Override
    public int readU2be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getShort() & 0xFFFF;
    }

    @Override
    public long readU4be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public int readU2le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getShort() & 0xFFFF;
    }

    @Override
    public long readU4le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public float readF4be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getFloat();
    }

    @Override
    public double readF8be() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getDouble();
    }

    @Override
    public float readF4le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getFloat();
    }

    @Override
    public double readF8le() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getDouble();
    }

    @Override
    public byte[] readBytes(long n) {
        byte[] buf = new byte[this.toByteArrayLength(n)];
        this.bb.get(buf);
        return buf;
    }

    @Override
    public byte[] readBytesFull() {
        byte[] buf = new byte[this.bb.remaining()];
        this.bb.get(buf);
        return buf;
    }

    @Override
    public byte[] readBytesTerm(int term, boolean includeTerm, boolean consumeTerm, boolean eosError) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while (true) {
            if (!this.bb.hasRemaining()) {
                if (eosError) {
                    throw new RuntimeException("End of stream reached, but no terminator " + term + " found");
                }
                return buf.toByteArray();
            }
            byte c = this.bb.get();
            if (c == term) {
                if (includeTerm) {
                    buf.write(c);
                }
                if (!consumeTerm) {
                    this.bb.position(this.bb.position() - 1);
                }
                return buf.toByteArray();
            }
            buf.write(c);
        }
    }
}

