/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.unlogged.command.AgentCommandExecutor;
import io.unlogged.command.AgentCommandRequest;
import io.unlogged.command.AgentCommandRequestType;
import io.unlogged.command.AgentCommandResponse;
import io.unlogged.command.ResponseType;
import io.unlogged.logging.IEventLogger;
import io.unlogged.util.ClassTypeUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AgentCommandExecutorImpl
implements AgentCommandExecutor {
    private final ObjectMapper objectMapper;
    private final IEventLogger logger;

    public AgentCommandExecutorImpl(ObjectMapper objectMapper, IEventLogger logger) {
        this.objectMapper = objectMapper;
        this.logger = logger;
    }

    private static void closeHibernateSessionIfPossible(Object sessionInstance) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (sessionInstance != null) {
            Method getTransactionMethod = sessionInstance.getClass().getMethod("getTransaction", new Class[0]);
            Object transactionInstance = getTransactionMethod.invoke(sessionInstance, new Object[0]);
            Method rollbackMethod = transactionInstance.getClass().getMethod("rollback", new Class[0]);
            rollbackMethod.invoke(transactionInstance, new Object[0]);
            Method sessionCloseMethod = sessionInstance.getClass().getMethod("close", new Class[0]);
            sessionCloseMethod.invoke(sessionInstance, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentCommandResponse executeCommand(AgentCommandRequest agentCommandRequest) throws Exception {
        AgentCommandRequestType requestType = agentCommandRequest.getRequestType();
        if (requestType == null) {
            requestType = AgentCommandRequestType.REPEAT_INVOKE;
        }
        try {
            AgentCommandResponse agentCommandResponse;
            if (requestType.equals((Object)AgentCommandRequestType.REPEAT_INVOKE)) {
                this.logger.setRecording(true);
            }
            Object sessionInstance = this.tryOpenHibernateSessionIfHibernateExists();
            try {
                Object objectInstanceByClass = null;
                objectInstanceByClass = this.logger.getObjectByClassName(agentCommandRequest.getClassName());
                List<String> alternateClassNames = agentCommandRequest.getAlternateClassNames();
                if (objectInstanceByClass == null && alternateClassNames != null && alternateClassNames.size() > 0) {
                    String alternateClassName;
                    Iterator<String> iterator2 = alternateClassNames.iterator();
                    while (iterator2.hasNext() && (objectInstanceByClass = this.logger.getObjectByClassName(alternateClassName = iterator2.next())) == null) {
                    }
                }
                ClassLoader targetClassLoader1 = this.logger.getTargetClassLoader();
                if (objectInstanceByClass == null) {
                    objectInstanceByClass = this.tryObjectConstruct(agentCommandRequest.getClassName(), targetClassLoader1);
                }
                Class<?> objectClass = objectInstanceByClass != null ? objectInstanceByClass.getClass() : Class.forName(agentCommandRequest.getClassName(), false, targetClassLoader1);
                ClassLoader targetClassLoader = objectInstanceByClass != null ? objectInstanceByClass.getClass().getClassLoader() : targetClassLoader1;
                Method methodToExecute = null;
                List<String> methodSignatureParts = ClassTypeUtil.splitMethodDesc(agentCommandRequest.getMethodSignature());
                String methodReturnType = methodSignatureParts.remove(methodSignatureParts.size() - 1);
                List<String> methodParameters = agentCommandRequest.getMethodParameters();
                Class[] methodParameterTypes = new Class[methodSignatureParts.size()];
                for (int i = 0; i < methodSignatureParts.size(); ++i) {
                    String methodSignaturePart = methodSignatureParts.get(i);
                    methodParameterTypes[i] = ClassTypeUtil.getClassNameFromDescriptor(methodSignaturePart, targetClassLoader);
                }
                ArrayList<Method> methodList = new ArrayList<Method>();
                while (objectClass != null && !objectClass.equals(Object.class)) {
                    try {
                        methodToExecute = objectClass.getMethod(agentCommandRequest.getMethodName(), methodParameterTypes);
                    }
                    catch (NoSuchMethodException methodSignaturePart) {
                        // empty catch block
                    }
                    if (methodToExecute == null) {
                        Method[] methods2;
                        for (Method method : methods2 = objectClass.getDeclaredMethods()) {
                            methodList.add(method);
                            if (!method.getName().equals(agentCommandRequest.getMethodName()) || method.getParameterCount() != methodParameters.size()) continue;
                            methodToExecute = method;
                            break;
                        }
                    }
                    if (methodToExecute != null) break;
                    objectClass = objectClass.getSuperclass();
                }
                if (methodToExecute == null) {
                    List methodNamesList = methodList.stream().map(Method::getName).collect(Collectors.toList());
                    System.err.println("Method not found: " + agentCommandRequest.getMethodName() + ", methods were: " + methodNamesList);
                    throw new NoSuchMethodException("method not found [" + agentCommandRequest.getMethodName() + "] in class [" + agentCommandRequest.getClassName() + "]. Available methods are: " + methodNamesList);
                }
                methodToExecute.setAccessible(true);
                Class<?>[] parameterTypesClass = methodToExecute.getParameterTypes();
                Object[] parameters2 = new Object[methodParameters.size()];
                TypeFactory typeFactory = this.objectMapper.getTypeFactory().withClassLoader(targetClassLoader);
                List<String> parameterTypes = agentCommandRequest.getParameterTypes();
                for (int i = 0; i < methodParameters.size(); ++i) {
                    Object parameterObject;
                    String methodParameter = methodParameters.get(i);
                    Class<?> parameterType = parameterTypesClass[i];
                    if (parameterType.getCanonicalName().equals("org.springframework.util.MultiValueMap")) {
                        parameterObject = this.objectMapper.readValue(methodParameter, Class.forName("org.springframework.util.LinkedMultiValueMap"));
                    } else {
                        JavaType typeReference;
                        try {
                            typeReference = typeFactory.constructFromCanonical(parameterTypes.get(i));
                        }
                        catch (Exception e) {
                            typeReference = typeFactory.constructType(parameterType);
                        }
                        parameterObject = this.objectMapper.readValue(methodParameter, typeReference);
                    }
                    parameters2[i] = parameterObject;
                }
                AgentCommandResponse agentCommandResponse2 = new AgentCommandResponse();
                agentCommandResponse2.setTargetClassName(agentCommandRequest.getClassName());
                agentCommandResponse2.setTargetMethodName(agentCommandRequest.getMethodName());
                agentCommandResponse2.setTargetMethodSignature(agentCommandRequest.getMethodSignature());
                agentCommandResponse2.setTimestamp(new Date().getTime());
                try {
                    CorePublisher returnedFlux;
                    Object methodReturnValue = methodToExecute.invoke(objectInstanceByClass, parameters2);
                    if (methodReturnValue instanceof Double) {
                        agentCommandResponse2.setMethodReturnValue(Double.doubleToLongBits((Double)methodReturnValue));
                    } else if (methodReturnValue instanceof Float) {
                        agentCommandResponse2.setMethodReturnValue(Float.floatToIntBits(((Float)methodReturnValue).floatValue()));
                    } else if (methodReturnValue instanceof Flux) {
                        returnedFlux = (Flux)methodReturnValue;
                        agentCommandResponse2.setMethodReturnValue(this.objectMapper.writeValueAsString(((Flux)returnedFlux).collectList().block()));
                    } else if (methodReturnValue instanceof Mono) {
                        returnedFlux = (Mono)methodReturnValue;
                        agentCommandResponse2.setMethodReturnValue(this.objectMapper.writeValueAsString(((Mono)returnedFlux).block()));
                    } else {
                        agentCommandResponse2.setMethodReturnValue(this.objectMapper.writeValueAsString(methodReturnValue));
                    }
                    agentCommandResponse2.setResponseClassName(methodToExecute.getReturnType().getCanonicalName());
                    agentCommandResponse2.setResponseType(ResponseType.NORMAL);
                }
                catch (Throwable exception) {
                    if (exception instanceof InvocationTargetException) {
                        exception.getCause().printStackTrace();
                    } else {
                        exception.printStackTrace();
                    }
                    Throwable exceptionCause = exception.getCause() != null ? exception.getCause() : exception;
                    agentCommandResponse2.setMessage(exceptionCause.getMessage());
                    try {
                        agentCommandResponse2.setMethodReturnValue(this.objectMapper.writeValueAsString(exceptionCause));
                    }
                    catch (Throwable e) {
                        agentCommandResponse2.setMethodReturnValue("Exception: " + exceptionCause.getMessage());
                        agentCommandResponse2.setMessage("Exception: " + exceptionCause.getMessage());
                    }
                    agentCommandResponse2.setResponseClassName(exceptionCause.getClass().getCanonicalName());
                    agentCommandResponse2.setResponseType(ResponseType.EXCEPTION);
                }
                agentCommandResponse = agentCommandResponse2;
            }
            catch (Throwable throwable) {
                AgentCommandExecutorImpl.closeHibernateSessionIfPossible(sessionInstance);
                throw throwable;
            }
            AgentCommandExecutorImpl.closeHibernateSessionIfPossible(sessionInstance);
            return agentCommandResponse;
        }
        finally {
            if (requestType.equals((Object)AgentCommandRequestType.REPEAT_INVOKE)) {
                this.logger.setRecording(false);
            }
        }
    }

    private Object tryObjectConstruct(String className, ClassLoader targetClassLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (targetClassLoader == null) {
            System.err.println("Failed to construct instance of class [" + className + "]. classLoader is not defined");
        }
        Class<?> loadedClass = targetClassLoader.loadClass(className);
        Constructor<?> noArgsConstructor = null;
        try {
            noArgsConstructor = loadedClass.getConstructor(new Class[0]);
            try {
                return noArgsConstructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchMethodException e) {
            Method[] methods2;
            for (Method method : methods2 = loadedClass.getMethods()) {
                if (method.getParameterCount() != 0 || !Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(loadedClass)) continue;
                try {
                    return method.invoke(null, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            throw new RuntimeException(e);
        }
    }

    private Object tryOpenHibernateSessionIfHibernateExists() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object hibernateSessionFactory = this.logger.getObjectByClassName("org.hibernate.internal.SessionFactoryImpl");
        Object sessionInstance = null;
        if (hibernateSessionFactory != null) {
            Method openSessionMethod = hibernateSessionFactory.getClass().getMethod("openSession", new Class[0]);
            sessionInstance = openSessionMethod.invoke(hibernateSessionFactory, new Object[0]);
            Class<?> managedSessionContextClass = Class.forName("org.hibernate.context.internal.ManagedSessionContext");
            Method bindMethod = managedSessionContextClass.getMethod("bind", Class.forName("org.hibernate.Session"));
            bindMethod.invoke(null, sessionInstance);
            Method beginTransactionMethod = sessionInstance.getClass().getMethod("beginTransaction", new Class[0]);
            beginTransactionMethod.invoke(sessionInstance, new Object[0]);
        }
        return sessionInstance;
    }
}

