/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged;

import io.unlogged.AgentCommandExecutorImpl;
import io.unlogged.Pair;
import io.unlogged.Unlogged;
import io.unlogged.command.AgentCommandServer;
import io.unlogged.command.ServerMetadata;
import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.IEventLogger;
import io.unlogged.logging.Logging;
import io.unlogged.logging.SimpleFileLogger;
import io.unlogged.logging.impl.DetailedEventStreamAggregatedLogger;
import io.unlogged.logging.perthread.PerThreadBinaryFileAggregatedLogger;
import io.unlogged.logging.perthread.RawFileCollector;
import io.unlogged.logging.util.FileNameGenerator;
import io.unlogged.logging.util.NetworkClient;
import io.unlogged.util.StreamUtil;
import io.unlogged.weaver.WeaveConfig;
import io.unlogged.weaver.WeaveParameters;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class Runtime {
    public static final int AGENT_SERVER_PORT = 12100;
    private static Runtime instance;
    private static List<Pair<String, List<Integer>>> pendingClassRegistrations;
    private final ScheduledExecutorService probeReaderExecutor = Executors.newSingleThreadScheduledExecutor();
    private AgentCommandServer httpServer;
    private IErrorLogger errorLogger;
    private IEventLogger logger = Logging.initialiseDiscardLogger();
    private long lastProbesLoadTime;

    private Runtime(String args2) {
        try {
            WeaveParameters weaveParameters = new WeaveParameters(args2);
            ServerMetadata serverMetadata = new ServerMetadata(weaveParameters.getIncludedNames().toString(), "1.0.1");
            this.httpServer = new AgentCommandServer(12100, serverMetadata);
            File outputDir = new File(weaveParameters.getOutputDirname());
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (!outputDir.isDirectory() || !outputDir.canWrite()) {
                System.err.println("[unlogged] ERROR: " + outputDir.getAbsolutePath() + " is not writable.");
                return;
            }
            WeaveConfig config = new WeaveConfig(weaveParameters);
            if (!config.isValid()) {
                System.out.println("[unlogged] no weaving option is specified.");
                return;
            }
            this.errorLogger = new SimpleFileLogger(outputDir);
            this.errorLogger.log("Java version: " + System.getProperty("java.version"));
            this.errorLogger.log("Agent version: 1.0.1");
            this.errorLogger.log("Params: " + args2);
            System.out.println("[unlogged] session Id: [" + config.getSessionId() + "] on hostname [" + NetworkClient.getHostname() + "]");
            URL probesToRecordUrl = this.getClass().getClassLoader().getResource("probes.dat");
            ArrayList<Integer> probesToRecord = new ArrayList();
            try {
                File file = new File(probesToRecordUrl.toURI());
                this.lastProbesLoadTime = file.lastModified();
                probesToRecord = this.probeFileToIdList(file);
            }
            catch (Exception e) {
                probesToRecordUrl = null;
                probesToRecord = this.probeFileStreamToIdList(this.getClass().getClassLoader().getResourceAsStream("probes.dat"));
            }
            switch (weaveParameters.getMode()) {
                case Discard: {
                    this.logger = Logging.initialiseDiscardLogger();
                }
                case PerThread: {
                    NetworkClient networkClient = new NetworkClient(weaveParameters.getServerAddress(), config.getSessionId(), weaveParameters.getAuthToken(), this.errorLogger);
                    FileNameGenerator fileNameGenerator1 = new FileNameGenerator(outputDir, "index-", ".zip");
                    RawFileCollector fileCollector = new RawFileCollector(weaveParameters.getFilesPerIndex(), fileNameGenerator1, networkClient, this.errorLogger, outputDir);
                    FileNameGenerator fileNameGenerator = new FileNameGenerator(outputDir, "log-", ".selog");
                    PerThreadBinaryFileAggregatedLogger perThreadBinaryFileAggregatedLogger = new PerThreadBinaryFileAggregatedLogger(fileNameGenerator, this.errorLogger, fileCollector);
                    this.logger = Logging.initialiseAggregatedLogger(perThreadBinaryFileAggregatedLogger, outputDir);
                    break;
                }
                case Testing: {
                    NetworkClient networkClient1 = new NetworkClient(weaveParameters.getServerAddress(), config.getSessionId(), weaveParameters.getAuthToken(), this.errorLogger);
                    FileNameGenerator archiveFileNameGenerator = new FileNameGenerator(outputDir, "index-", ".zip");
                    RawFileCollector fileCollector1 = new RawFileCollector(weaveParameters.getFilesPerIndex(), archiveFileNameGenerator, networkClient1, this.errorLogger, outputDir);
                    FileNameGenerator logFileNameGenerator = new FileNameGenerator(outputDir, "log-", ".selog");
                    PerThreadBinaryFileAggregatedLogger perThreadBinaryFileAggregatedLogger1 = new PerThreadBinaryFileAggregatedLogger(logFileNameGenerator, this.errorLogger, fileCollector1);
                    this.logger = Logging.initialiseDetailedAggregatedLogger(perThreadBinaryFileAggregatedLogger1, outputDir, probesToRecord);
                    DetailedEventStreamAggregatedLogger detailedLogger = (DetailedEventStreamAggregatedLogger)this.logger;
                    if (probesToRecordUrl == null) break;
                    URL finalProbesToRecordUrl = probesToRecordUrl;
                    this.probeReaderExecutor.scheduleWithFixedDelay(() -> {
                        try {
                            File probesFile = new File(finalProbesToRecordUrl.toURI());
                            if (!probesFile.exists()) {
                                return;
                            }
                            long newProbesFileModifiedTime = probesFile.lastModified();
                            if (newProbesFileModifiedTime > this.lastProbesLoadTime) {
                                this.lastProbesLoadTime = newProbesFileModifiedTime;
                                List<Integer> newProbeIdList = this.probeFileToIdList(probesFile);
                                detailedLogger.setProbesToRecord(newProbeIdList);
                            }
                        }
                        catch (IOException | URISyntaxException exception) {
                            // empty catch block
                        }
                    }, 1000L, 300L, TimeUnit.MILLISECONDS);
                }
            }
            this.httpServer.setAgentCommandExecutor(new AgentCommandExecutorImpl(this.logger.getObjectMapper(), this.logger));
            this.httpServer.start(5000, false);
            java.lang.Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
        }
        catch (Throwable thx) {
            thx.printStackTrace();
            System.err.println("[unlogged] agent init failed, this session will not be recorded => " + thx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runtime getInstance(String args2) {
        if (instance != null) {
            return instance;
        }
        Class<Runtime> clazz = Runtime.class;
        synchronized (Runtime.class) {
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            try {
                StackTraceElement callerClassAndMethodStack = new Exception().getStackTrace()[1];
                Class<?> callerClass = Class.forName(callerClassAndMethodStack.getClassName());
                for (Method method : callerClass.getMethods()) {
                    if (method.getAnnotation(Unlogged.class) == null) continue;
                    Unlogged annotationData = method.getAnnotation(Unlogged.class);
                    if (!annotationData.enable()) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            instance = new Runtime(args2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @NotNull
    private List<Integer> probeFileToIdList(File file) throws IOException {
        InputStream probesFile = this.getClass().getClassLoader().getResourceAsStream(file.getName());
        return this.probeFileStreamToIdList(probesFile);
    }

    @NotNull
    private List<Integer> probeFileStreamToIdList(InputStream probesFile) throws IOException {
        ArrayList<Integer> probesToRecord = new ArrayList<Integer>();
        if (probesFile == null) {
            return probesToRecord;
        }
        byte[] probeToRecordBytes = StreamUtil.streamToBytes(probesFile);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(probeToRecordBytes));
        try {
            while (true) {
                int probeId = dis.readInt();
                probesToRecord.add(probeId);
            }
        }
        catch (EOFException eOFException) {
            return probesToRecord;
        }
    }

    public void close() {
        if (this.logger != null) {
            this.logger.close();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        if (this.errorLogger != null) {
            this.errorLogger.close();
        }
        System.out.println("[unlogged] shutdown complete");
    }

    static {
        pendingClassRegistrations = new ArrayList<Pair<String, List<Integer>>>();
    }

    public static enum Mode {
        Stream,
        Frequency,
        FixedSize,
        Discard,
        Network,
        PerThread,
        Testing;

    }
}

