/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.command;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fi.iki.elonen.NanoHTTPD;
import io.unlogged.command.AgentCommandErrorResponse;
import io.unlogged.command.AgentCommandExecutor;
import io.unlogged.command.AgentCommandRequest;
import io.unlogged.command.AgentCommandResponse;
import io.unlogged.command.ResponseType;
import io.unlogged.command.ServerMetadata;
import java.io.IOException;
import java.util.HashMap;

public class AgentCommandServer
extends NanoHTTPD {
    private final ServerMetadata serverMetadata;
    ObjectMapper objectMapper = new ObjectMapper();
    private AgentCommandExecutor agentCommandExecutor;
    private String pingResponseBody;

    public AgentCommandServer(int port, ServerMetadata serverMetadata) {
        super(port);
        this.serverMetadata = serverMetadata;
        this.init();
    }

    public AgentCommandServer(String hostname, int port, ServerMetadata serverMetadata) {
        super(hostname, port);
        this.serverMetadata = serverMetadata;
        this.init();
    }

    public void init() {
        AgentCommandResponse pingResponse = new AgentCommandResponse();
        pingResponse.setMessage("ok");
        pingResponse.setResponseType(ResponseType.NORMAL);
        try {
            pingResponse.setMethodReturnValue(this.serverMetadata);
            this.pingResponseBody = this.objectMapper.writeValueAsString(pingResponse);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String requestBodyText = null;
        HashMap<String, String> bodyParams = new HashMap<String, String>();
        try {
            session.parseBody(bodyParams);
        }
        catch (NanoHTTPD.ResponseException | IOException e) {
            return AgentCommandServer.newFixedLengthResponse("{\"message\": \"" + e.getMessage() + "\", }");
        }
        requestBodyText = (String)bodyParams.get("postData");
        String postBody = session.getQueryParameterString();
        String requestPath = session.getUri();
        NanoHTTPD.Method requestMethod = session.getMethod();
        if (requestPath.equals("/ping")) {
            return AgentCommandServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", this.pingResponseBody);
        }
        try {
            AgentCommandResponse commandResponse;
            AgentCommandRequest agentCommandRequest = this.objectMapper.readValue(postBody != null ? postBody : requestBodyText, AgentCommandRequest.class);
            switch (agentCommandRequest.getCommand()) {
                case EXECUTE: {
                    commandResponse = this.agentCommandExecutor.executeCommand(agentCommandRequest);
                    break;
                }
                default: {
                    System.err.println("Unknown request [" + (Object)((Object)requestMethod) + "] " + requestPath + " - " + agentCommandRequest);
                    commandResponse = new AgentCommandResponse();
                    commandResponse.setMessage("unknown command: " + (Object)((Object)agentCommandRequest.getCommand()));
                    commandResponse.setResponseType(ResponseType.FAILED);
                }
            }
            String responseBody = this.objectMapper.writeValueAsString(commandResponse);
            return AgentCommandServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
            AgentCommandErrorResponse agentCommandErrorResponse = new AgentCommandErrorResponse(e.getMessage());
            if (e instanceof NoSuchMethodException) {
                agentCommandErrorResponse.setResponseType(ResponseType.FAILED);
            } else {
                agentCommandErrorResponse.setResponseType(ResponseType.EXCEPTION);
            }
            String errorResponseBody = null;
            try {
                errorResponseBody = this.objectMapper.writeValueAsString(agentCommandErrorResponse);
            }
            catch (JsonProcessingException ex) {
                return AgentCommandServer.newFixedLengthResponse("{\"message\": \"" + ex.getMessage() + "\"}");
            }
            return AgentCommandServer.newFixedLengthResponse(errorResponseBody);
        }
    }

    public void setAgentCommandExecutor(AgentCommandExecutor agentCommandExecutor) {
        this.agentCommandExecutor = agentCommandExecutor;
    }
}

