/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.impl;

import com.esotericsoftware.kryo.Kryo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.insidious.common.weaver.ClassInfo;
import io.unlogged.logging.IEventLogger;
import io.unlogged.logging.SerializationMode;
import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.ObjectIdAggregatedStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetailedEventStreamAggregatedLogger
implements IEventLogger {
    public static final Duration MILLI_1 = Duration.of(1L, ChronoUnit.MILLIS);
    private final List<String> JACKSON_PROPERTY_NAMES_SET_FALSE = Arrays.asList("FAIL_ON_UNKNOWN_PROPERTIES", "FAIL_ON_IGNORED_PROPERTIES", "FAIL_ON_NULL_FOR_PRIMITIVES", "FAIL_ON_NULL_CREATOR_PROPERTIES", "FAIL_ON_MISSING_CREATOR_PROPERTIES", "FAIL_ON_NUMBERS_FOR_ENUMS", "FAIL_ON_TRAILING_TOKENS");
    private final AggregatedFileLogger aggregatedLogger;
    private final ObjectIdAggregatedStream objectIdMap;
    private final Boolean DEBUG = Boolean.parseBoolean(System.getProperty("UNLOGGED_DEBUG"));
    private final ThreadLocal<Boolean> isRecording = ThreadLocal.withInitial(() -> false);
    private final boolean serializeValues = true;
    private final Set<Integer> probesToRecord = new HashSet<Integer>();
    private final SerializationMode SERIALIZATION_MODE = SerializationMode.JACKSON;
    private final ThreadLocal<ByteArrayOutputStream> output = ThreadLocal.withInitial(() -> new ByteArrayOutputStream(1000000));
    private final Kryo kryo;
    private final Map<String, WeakReference<Object>> objectMap = new HashMap<String, WeakReference<Object>>();
    private boolean isLombokPresent;
    private ClassLoader targetClassLoader;
    private final ThreadLocal<ObjectMapper> objectMapper = ThreadLocal.withInitial(() -> {
        String jacksonVersion = ObjectMapper.class.getPackage().getImplementationVersion();
        if (jacksonVersion != null && (jacksonVersion.startsWith("2.9") || jacksonVersion.startsWith("2.8"))) {
            ObjectMapper objectMapper1 = new ObjectMapper();
            for (DeserializationFeature value : DeserializationFeature.values()) {
                if (!this.JACKSON_PROPERTY_NAMES_SET_FALSE.contains(value.name())) continue;
                objectMapper1.configure(value, false);
            }
            return objectMapper1;
        }
        JsonMappingException jme = new JsonMappingException(new DummyClosable(), "load class");
        jme.prependPath(new JsonMappingException.Reference("from dummy"));
        JsonMapper.Builder jacksonBuilder = JsonMapper.builder();
        for (DeserializationFeature value : DeserializationFeature.values()) {
            if (!this.JACKSON_PROPERTY_NAMES_SET_FALSE.contains(value.name())) continue;
            jacksonBuilder.configure(value, false);
        }
        jacksonBuilder.annotationIntrospector(new JacksonAnnotationIntrospector(){

            @Override
            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return false;
            }

            @Override
            public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
                if (ac.hasAnnotation(JsonPOJOBuilder.class)) {
                    return super.findPOJOBuilderConfig(ac);
                }
                return new JsonPOJOBuilder.Value("build", "");
            }

            @Override
            public Class<?> findPOJOBuilder(AnnotatedClass ac) {
                if (DetailedEventStreamAggregatedLogger.this.isLombokPresent) {
                    try {
                        String classFullyQualifiedName = ac.getName();
                        String classSimpleName = classFullyQualifiedName.substring(classFullyQualifiedName.lastIndexOf(".") + 1);
                        String lombokClassBuilderName = ac.getName() + "$" + classSimpleName + "Builder";
                        return DetailedEventStreamAggregatedLogger.this.targetClassLoader.loadClass(lombokClassBuilderName);
                    }
                    catch (ClassNotFoundException e) {
                        return super.findPOJOBuilder(ac);
                    }
                }
                return super.findPOJOBuilder(ac);
            }
        });
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy HH:mm:ss aaa");
        jacksonBuilder.defaultDateFormat(df);
        jacksonBuilder.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        jacksonBuilder.configure(SerializationFeature.FAIL_ON_SELF_REFERENCES, false);
        try {
            Field fieldWriteSelfReferencesAsNull = SerializationFeature.class.getDeclaredField("WRITE_SELF_REFERENCES_AS_NULL");
            jacksonBuilder.configure(SerializationFeature.WRITE_SELF_REFERENCES_AS_NULL, true);
        }
        catch (NoSuchFieldException fieldWriteSelfReferencesAsNull) {
            // empty catch block
        }
        try {
            Class.forName("javax.persistence.ElementCollection");
            Class<?> hibernateClassPresent = Class.forName("org.hibernate.SessionFactory");
            Class<?> hibernateModule = Class.forName("com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module");
            Module module = (Module)hibernateModule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> featureClass = Class.forName("com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module$Feature");
            Method configureMethod = hibernateModule.getMethod("configure", featureClass, Boolean.TYPE);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("FORCE_LAZY_LOADING").get(null), true);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("REPLACE_PERSISTENT_COLLECTIONS").get(null), true);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("USE_TRANSIENT_ANNOTATION").get(null), false);
            jacksonBuilder.addModule(module);
        }
        catch (ClassNotFoundException | NoSuchMethodException hibernateClassPresent) {
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        List<String> jacksonModules = Arrays.asList("com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "com.fasterxml.jackson.datatype.joda.JodaModule", "com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule", "com.fasterxml.jackson.module.mrbean.MrBeanModule", "com.fasterxml.jackson.module.paranamer.ParanamerModule");
        for (String jacksonModule : jacksonModules) {
            try {
                Class<?> jdk8Module = Class.forName(jacksonModule);
                jacksonBuilder.addModule((Module)jdk8Module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException jdk8Module) {
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> kotlinModuleClass = Class.forName("com.fasterxml.jackson.module.kotlin.KotlinModule");
            KotlinModule kotlinModule2 = new KotlinModule.Builder().build();
            jacksonBuilder.addModule(kotlinModule2);
        }
        catch (ClassNotFoundException kotlinModuleClass) {
            // empty catch block
        }
        JsonMapper objectMapperInstance = (JsonMapper)jacksonBuilder.build();
        objectMapperInstance.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return objectMapperInstance;
    });

    public DetailedEventStreamAggregatedLogger(ObjectIdAggregatedStream objectIdMap, AggregatedFileLogger aggregatedLogger, List<Integer> probesToRecord) {
        this.aggregatedLogger = aggregatedLogger;
        this.objectIdMap = objectIdMap;
        this.probesToRecord.addAll(probesToRecord);
        try {
            Class<?> lombokBuilderAnnotation = Class.forName("lombok.Builder");
            this.isLombokPresent = true;
        }
        catch (ClassNotFoundException e) {
            this.isLombokPresent = false;
        }
        if (this.SERIALIZATION_MODE == SerializationMode.KRYO) {
            this.kryo = new Kryo();
            this.kryo.register(byte[].class);
            this.kryo.register(LinkedHashMap.class);
            this.kryo.register(LinkedHashSet.class);
        } else {
            this.kryo = this.SERIALIZATION_MODE == SerializationMode.JACKSON ? null : (this.SERIALIZATION_MODE == SerializationMode.FST ? null : null);
        }
    }

    public ObjectIdAggregatedStream getObjectIdMap() {
        return this.objectIdMap;
    }

    @Override
    public void close() {
        this.objectIdMap.close();
        try {
            this.aggregatedLogger.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getObjectByClassName(String className) {
        if (!this.objectMap.containsKey(className)) {
            return null;
        }
        WeakReference<Object> objectWeakReference = this.objectMap.get(className);
        Object objectInstance2 = objectWeakReference.get();
        if (objectInstance2 == null) {
            this.objectMap.remove(className);
            return null;
        }
        if (this.targetClassLoader == null) {
            this.targetClassLoader = objectInstance2.getClass().getClassLoader();
        }
        return objectInstance2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordEvent(int dataId, Object value) {
        String className;
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        if (value != null) {
            className = value.getClass().getCanonicalName();
            if (className == null) {
                className = value.getClass().getName();
            }
        } else {
            className = "";
        }
        if (!className.contains("Lambda")) {
            if (className.contains("_$")) {
                className = className.substring(0, className.indexOf("_$"));
            } else if (className.contains("$")) {
                className = className.substring(0, className.indexOf(36));
            }
            this.objectMap.put(className, new WeakReference<Object>(value));
            if (this.targetClassLoader == null && value != null) {
                this.targetClassLoader = value.getClass().getClassLoader();
            }
        }
        long objectId = this.objectIdMap.getId(value);
        if (this.probesToRecord.size() > 0 && this.probesToRecord.contains(dataId)) {
            if (this.DEBUG.booleanValue() && value != null) {
                System.out.println("record serialized value for probe [" + dataId + "] -> " + value.getClass());
            }
            byte[] bytes = new byte[]{};
            try {
                this.isRecording.set(true);
                if (value instanceof Class) {
                    bytes = ((Class)value).getCanonicalName().getBytes(StandardCharsets.UTF_8);
                } else if (className.startsWith("com.google") || className.startsWith("org.apache.http") || className.startsWith("java.util.stream") || className.startsWith("org.elasticsearch.client") || className.startsWith("org.hibernate") || className.startsWith("ch.qos") || className.startsWith("io.dropwizard") || className.contains("java.lang.reflect") || className.startsWith("org.redis") || className.startsWith("redis") || className.startsWith("co.elastic") || className.startsWith("io.unlogged") || className.startsWith("java.lang.Class") || className.startsWith("io.undertow") || className.startsWith("org.thymeleaf") || className.startsWith("tech.jhipster") || className.startsWith("com.github") || className.startsWith("com.zaxxer") || className.startsWith("org.glassfish") && !className.equals("org.glassfish.jersey.message.internal.OutboundJaxrsResponse") || className.startsWith("com.fasterxml") || className.startsWith("selogger.org.slf4j") || className.startsWith("org.springframework") && !className.startsWith("org.springframework.http") && !className.startsWith("org.springframework.data.domain") || className.startsWith("java.io") || className.contains("$Lambda$") || className.contains("$$EnhancerBySpringCGLIB$$") || className.startsWith("java.util.regex") || className.startsWith("java.util.Base64") || className.startsWith("java.util.concurrent") || className.startsWith("com.amazon") || className.startsWith("com.hubspot") || value instanceof Iterator) {
                    this.probesToRecord.remove(dataId);
                } else if (this.SERIALIZATION_MODE == SerializationMode.JACKSON) {
                    bytes = this.objectMapper.get().writeValueAsBytes(value);
                    if (this.DEBUG.booleanValue()) {
                        System.err.println("[" + dataId + "] record serialized value for probe [" + value.getClass() + "] [" + objectId + "] -> " + new String(bytes));
                    }
                } else if (this.SERIALIZATION_MODE == SerializationMode.FST) {
                } else if (this.SERIALIZATION_MODE == SerializationMode.OOS) {
                } else if (this.SERIALIZATION_MODE == SerializationMode.KRYO) {
                    // empty if block
                }
            }
            catch (Throwable e) {
                this.probesToRecord.remove(dataId);
            }
            finally {
                this.isRecording.set(false);
            }
            this.aggregatedLogger.writeEvent(dataId, objectId, bytes);
        } else {
            this.aggregatedLogger.writeEvent(dataId, objectId);
        }
    }

    @Override
    public void recordEvent(int dataId, int value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, long value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, byte value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, short value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, char value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, boolean value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        int longValue = value ? 1 : 0;
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, double value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        long longValue = Double.doubleToRawLongBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, float value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        int longValue = Float.floatToRawIntBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordWeaveInfo(byte[] byteArray, ClassInfo classIdEntry, List<Integer> probeIdsToRecord) {
        if (!(classIdEntry.getClassName().contains("mongo") || classIdEntry.getClassName().contains("spring") || classIdEntry.getClassName().contains("redis"))) {
            this.probesToRecord.addAll(probeIdsToRecord);
        }
        this.aggregatedLogger.writeWeaveInfo(byteArray);
    }

    @Override
    public void setRecording(boolean b) {
        this.isRecording.set(b);
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper.get();
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.targetClassLoader;
    }

    @Override
    public void registerClass(Integer id, Class<?> type2) {
    }

    public void setProbesToRecord(List<Integer> newProbeIdList) {
        this.probesToRecord.addAll(newProbeIdList);
    }

    private static class DummyClosable
    implements Closeable {
        private DummyClosable() {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

