/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.insidious.common.weaver.ClassInfo;
import io.unlogged.logging.IEventLogger;
import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.ObjectIdAggregatedStream;
import java.util.Date;
import java.util.List;

public class EventStreamAggregatedLogger
implements IEventLogger {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AggregatedFileLogger aggregatedLogger;
    private final ObjectIdAggregatedStream objectIdMap;

    public EventStreamAggregatedLogger(ObjectIdAggregatedStream objectIdMap, AggregatedFileLogger aggregatedLogger) {
        this.aggregatedLogger = aggregatedLogger;
        this.objectIdMap = objectIdMap;
    }

    @Override
    public void registerClass(Integer id, Class<?> type2) {
    }

    public ObjectIdAggregatedStream getObjectIdMap() {
        return this.objectIdMap;
    }

    @Override
    public void close() {
        System.out.println("[unlogged] close event stream aggregated logger");
        this.objectIdMap.close();
        try {
            this.aggregatedLogger.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getObjectByClassName(String name) {
        return null;
    }

    @Override
    public void recordEvent(int dataId, Object value) {
        long objectId = this.objectIdMap.getId(value);
        this.aggregatedLogger.writeEvent(dataId, objectId);
    }

    public void recordEvent(int dataId, Integer value) {
        if (value == null) {
            this.aggregatedLogger.writeEvent(dataId, 0L);
        } else {
            this.aggregatedLogger.writeEvent(dataId, value.longValue());
        }
    }

    public void recordEvent(int dataId, Long value) {
        if (value == null) {
            this.aggregatedLogger.writeEvent(dataId, 0L);
        } else {
            this.aggregatedLogger.writeEvent(dataId, value);
        }
    }

    public void recordEvent(int dataId, Short value) {
        if (value == null) {
            this.aggregatedLogger.writeEvent(dataId, 0L);
        } else {
            this.aggregatedLogger.writeEvent(dataId, value.longValue());
        }
    }

    public void recordEvent(int dataId, Boolean value) {
        this.aggregatedLogger.writeEvent(dataId, value == null ? 0L : (value != false ? 1L : 0L));
    }

    public void recordEvent(int dataId, Float value) {
        if (value == null) {
            this.aggregatedLogger.writeEvent(dataId, 0L);
        } else {
            this.aggregatedLogger.writeEvent(dataId, value.longValue());
        }
    }

    public void recordEvent(int dataId, Byte value) {
        this.aggregatedLogger.writeEvent(dataId, value.byteValue());
    }

    public void recordEvent(int dataId, Date value) {
        if (value == null) {
            this.aggregatedLogger.writeEvent(dataId, 0L);
        } else {
            this.aggregatedLogger.writeEvent(dataId, value.getTime());
        }
    }

    public void recordEvent(int dataId, Double value) {
        long longValue = Double.doubleToRawLongBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, int value) {
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, long value) {
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, byte value) {
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, short value) {
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, char value) {
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, boolean value) {
        int longValue = value ? 1 : 0;
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, double value) {
        long longValue = Double.doubleToRawLongBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, float value) {
        int longValue = Float.floatToRawIntBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordWeaveInfo(byte[] byteArray, ClassInfo classIdEntry, List<Integer> probeIdsToRecord) {
        this.aggregatedLogger.writeWeaveInfo(byteArray);
    }

    @Override
    public void setRecording(boolean b) {
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return null;
    }
}

