/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.perthread;

import com.insidious.common.UploadFile;
import com.insidious.common.cqengine.ObjectInfoDocument;
import com.insidious.common.cqengine.StringInfoDocument;
import com.insidious.common.cqengine.TypeInfoDocument;
import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.perthread.IndexOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import selogger.com.googlecode.cqengine.ConcurrentIndexedCollection;
import selogger.com.googlecode.cqengine.index.hash.HashIndex;
import selogger.com.googlecode.cqengine.index.radixinverted.InvertedRadixTreeIndex;
import selogger.com.googlecode.cqengine.persistence.disk.DiskPersistence;

public class ArchivedIndexWriter
implements IndexOutputStream {
    public static final String WEAVE_DAT_FILE = "class.weave.dat";
    public static final String INDEX_TYPE_DAT_FILE = "index.type.dat";
    public static final String INDEX_STRING_DAT_FILE = "index.string.dat";
    public static final String INDEX_OBJECT_DAT_FILE = "index.object.dat";
    public static final String INDEX_EVENTS_DAT_FILE = "index.events.dat";
    private final IErrorLogger errorLogger;
    private final Lock indexWriterLock = new ReentrantLock();
    private final String outputDir;
    private final File currentArchiveFile;
    private final String classWeavePath;
    private BlockingQueue<StringInfoDocument> stringsToIndex;
    private BlockingQueue<TypeInfoDocument> typesToIndex;
    private BlockingQueue<ObjectInfoDocument> objectsToIndex;
    private ConcurrentIndexedCollection<TypeInfoDocument> typeInfoIndex;
    private ConcurrentIndexedCollection<StringInfoDocument> stringInfoIndex;
    private ConcurrentIndexedCollection<ObjectInfoDocument> objectInfoIndex;
    private DiskPersistence<ObjectInfoDocument, Long> objectInfoDocumentIntegerDiskPersistence;
    private DiskPersistence<StringInfoDocument, Long> stringInfoDocumentStringDiskPersistence;
    private DiskPersistence<TypeInfoDocument, Integer> typeInfoDocumentStringDiskPersistence;
    private List<UploadFile> fileListToUpload = new LinkedList<UploadFile>();
    private ZipOutputStream archivedIndexOutputStream;

    public ArchivedIndexWriter(File archiveFile, String classWeaveFileStream, IErrorLogger errorLogger) throws IOException {
        this.errorLogger = errorLogger;
        this.classWeavePath = classWeaveFileStream;
        this.outputDir = archiveFile.getParent() + "/";
        this.currentArchiveFile = archiveFile;
        this.initIndexQueues();
        errorLogger.log("prepare index archive: " + this.currentArchiveFile.getName());
        this.archivedIndexOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.currentArchiveFile)));
        this.initialiseIndexes();
        errorLogger.log("completed preparing indexes for archive: " + this.currentArchiveFile.getName());
    }

    public File getArchiveFile() {
        return this.currentArchiveFile;
    }

    private void initIndexQueues() {
        this.typesToIndex = new ArrayBlockingQueue<TypeInfoDocument>(1);
        this.objectsToIndex = new ArrayBlockingQueue<ObjectInfoDocument>(1);
        this.stringsToIndex = new ArrayBlockingQueue<StringInfoDocument>(1);
    }

    private void initialiseIndexes() {
        String archiveName = this.currentArchiveFile.getName().split(".zip")[0];
        File typeIndexFile = new File(this.outputDir + archiveName + "-" + INDEX_TYPE_DAT_FILE);
        File stringIndexFile = new File(this.outputDir + archiveName + "-" + INDEX_STRING_DAT_FILE);
        File objectIndexFile = new File(this.outputDir + archiveName + "-" + INDEX_OBJECT_DAT_FILE);
        if (typeIndexFile.exists()) {
            typeIndexFile.delete();
        }
        if (stringIndexFile.exists()) {
            stringIndexFile.delete();
        }
        if (objectIndexFile.exists()) {
            objectIndexFile.delete();
        }
        this.typeInfoDocumentStringDiskPersistence = DiskPersistence.onPrimaryKeyInFile(TypeInfoDocument.TYPE_ID, typeIndexFile);
        this.stringInfoDocumentStringDiskPersistence = DiskPersistence.onPrimaryKeyInFile(StringInfoDocument.STRING_ID, stringIndexFile);
        this.objectInfoDocumentIntegerDiskPersistence = DiskPersistence.onPrimaryKeyInFile(ObjectInfoDocument.OBJECT_ID, objectIndexFile);
        this.typeInfoIndex = new ConcurrentIndexedCollection<TypeInfoDocument>(this.typeInfoDocumentStringDiskPersistence);
        this.stringInfoIndex = new ConcurrentIndexedCollection<StringInfoDocument>(this.stringInfoDocumentStringDiskPersistence);
        this.objectInfoIndex = new ConcurrentIndexedCollection<ObjectInfoDocument>(this.objectInfoDocumentIntegerDiskPersistence);
        this.typeInfoIndex.addIndex(HashIndex.onAttribute(TypeInfoDocument.TYPE_NAME));
        this.stringInfoIndex.addIndex(InvertedRadixTreeIndex.onAttribute(StringInfoDocument.STRING_VALUE));
        this.objectInfoIndex.addIndex(HashIndex.onAttribute(ObjectInfoDocument.OBJECT_TYPE_ID));
    }

    @Override
    public void drainQueueToIndex(List<ObjectInfoDocument> objectsToIndex, Queue<TypeInfoDocument> typesToIndex, List<StringInfoDocument> stringsToIndex) {
        this.errorLogger.log("drain queue to index: " + this.currentArchiveFile.getName() + ": [" + objectsToIndex.size() + "] [" + typesToIndex.size() + "] [" + stringsToIndex.size() + "]");
        long start = System.currentTimeMillis();
        int itemCount = objectsToIndex.size() + typesToIndex.size() + stringsToIndex.size();
        if (itemCount == 0) {
            return;
        }
        this.objectInfoIndex.addAll((Collection<ObjectInfoDocument>)objectsToIndex);
        this.typeInfoIndex.addAll((Collection<TypeInfoDocument>)typesToIndex);
        this.stringInfoIndex.addAll((Collection<StringInfoDocument>)stringsToIndex);
        long end = System.currentTimeMillis();
        this.errorLogger.log("Took [" + (end - start) / 1000L + "] seconds to index [" + itemCount + "] items");
    }

    @Override
    public int fileCount() {
        return this.fileListToUpload.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeArchive(BlockingQueue<StringInfoDocument> stringsToIndexTemp, BlockingQueue<ObjectInfoDocument> objectsToIndexTemp, BlockingQueue<TypeInfoDocument> typesToIndexTemp) {
        this.indexWriterLock.lock();
        long start = System.currentTimeMillis();
        this.errorLogger.log("lock acquired to finish archive: " + this.currentArchiveFile.getName());
        try {
            long endTime = new Date().getTime();
            try {
                ZipEntry classWeaveEntry = new ZipEntry(WEAVE_DAT_FILE);
                this.archivedIndexOutputStream.putNextEntry(classWeaveEntry);
                InputStream weaveInputStream = this.getClass().getClassLoader().getResourceAsStream(this.classWeavePath);
                this.copy(weaveInputStream, this.archivedIndexOutputStream);
                weaveInputStream.close();
                this.archivedIndexOutputStream.closeEntry();
                ZipEntry indexEntry = new ZipEntry(INDEX_EVENTS_DAT_FILE);
                this.archivedIndexOutputStream.putNextEntry(indexEntry);
                DataOutputStream outputStream = new DataOutputStream(this.archivedIndexOutputStream);
                List<UploadFile> fileIndexBytesCopy = this.fileListToUpload;
                this.fileListToUpload = new LinkedList<UploadFile>();
                outputStream.writeInt(fileIndexBytesCopy.size());
                for (UploadFile fileToUpload : fileIndexBytesCopy) {
                    outputStream.writeInt(fileToUpload.path.length());
                    outputStream.writeBytes(fileToUpload.path);
                    outputStream.writeLong(fileToUpload.threadId);
                    byte[] valueByteArray = new byte[]{};
                    byte[] probeByteArray = new byte[]{};
                    outputStream.writeInt(valueByteArray.length);
                    outputStream.write(valueByteArray);
                    outputStream.writeInt(probeByteArray.length);
                    outputStream.write(probeByteArray);
                }
                byte[] aggregatedValueFilterSerialized = new byte[]{};
                byte[] aggregatedProbeFilterSerialized = new byte[]{};
                outputStream.writeInt(aggregatedValueFilterSerialized.length);
                outputStream.write(aggregatedValueFilterSerialized);
                outputStream.writeInt(aggregatedProbeFilterSerialized.length);
                outputStream.write(aggregatedProbeFilterSerialized);
                outputStream.writeLong(endTime);
                outputStream.flush();
                this.archivedIndexOutputStream.closeEntry();
                ArrayList<ObjectInfoDocument> pendingObjects = new ArrayList<ObjectInfoDocument>(objectsToIndexTemp.size() + 1);
                ArrayBlockingQueue<TypeInfoDocument> pendingTypes = new ArrayBlockingQueue<TypeInfoDocument>(typesToIndexTemp.size() + 1);
                ArrayList<StringInfoDocument> pendingStrings = new ArrayList<StringInfoDocument>();
                stringsToIndexTemp.drainTo(pendingStrings);
                objectsToIndexTemp.drainTo(pendingObjects);
                typesToIndexTemp.drainTo(pendingTypes);
                this.drainQueueToIndex(pendingObjects, pendingTypes, pendingStrings);
                String currentArchiveName = this.currentArchiveFile.getName().split(".zip")[0];
                this.errorLogger.log("Close sqlite disk persistence for: " + currentArchiveName);
                this.objectInfoDocumentIntegerDiskPersistence.close();
                this.stringInfoDocumentStringDiskPersistence.close();
                this.typeInfoDocumentStringDiskPersistence.close();
                ZipEntry stringIndexEntry = new ZipEntry(INDEX_STRING_DAT_FILE);
                this.archivedIndexOutputStream.putNextEntry(stringIndexEntry);
                Path stringIndexFilePath = FileSystems.getDefault().getPath(this.outputDir + currentArchiveName + "-" + INDEX_STRING_DAT_FILE, new String[0]);
                Files.copy(stringIndexFilePath, this.archivedIndexOutputStream);
                stringIndexFilePath.toFile().delete();
                this.archivedIndexOutputStream.closeEntry();
                ZipEntry typeIndexEntry = new ZipEntry(INDEX_TYPE_DAT_FILE);
                this.archivedIndexOutputStream.putNextEntry(typeIndexEntry);
                Path typeIndexFilePath = FileSystems.getDefault().getPath(this.outputDir + currentArchiveName + "-" + INDEX_TYPE_DAT_FILE, new String[0]);
                Files.copy(typeIndexFilePath, this.archivedIndexOutputStream);
                typeIndexFilePath.toFile().delete();
                this.archivedIndexOutputStream.closeEntry();
                ZipEntry objectIndexEntry = new ZipEntry(INDEX_OBJECT_DAT_FILE);
                this.archivedIndexOutputStream.putNextEntry(objectIndexEntry);
                Path objectIndexFilePath = FileSystems.getDefault().getPath(this.outputDir + currentArchiveName + "-" + INDEX_OBJECT_DAT_FILE, new String[0]);
                Files.copy(objectIndexFilePath, this.archivedIndexOutputStream);
                objectIndexFilePath.toFile().delete();
                this.archivedIndexOutputStream.closeEntry();
            }
            catch (IOException e) {
                this.errorLogger.log(e);
            }
            finally {
                this.archivedIndexOutputStream.close();
            }
        }
        catch (Exception e) {
            this.errorLogger.log(e);
        }
        finally {
            long end = System.currentTimeMillis();
            this.errorLogger.log("Took [" + (end - start) / 1000L + "] seconds to complete archive: " + this.currentArchiveFile.getName());
            try {
                this.indexWriterLock.unlock();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        this.completeArchive(this.stringsToIndex, this.objectsToIndex, this.typesToIndex);
    }

    @Override
    public void writeFileEntry(UploadFile logFile) throws IOException {
        long currentTimestamp = System.currentTimeMillis();
        File fileToUpload = new File(logFile.path);
        this.fileListToUpload.add(logFile);
        String fileName = currentTimestamp + "@" + fileToUpload.getName();
        ZipEntry eventsFileZipEntry = new ZipEntry(fileName);
        this.archivedIndexOutputStream.putNextEntry(eventsFileZipEntry);
        FileInputStream fis = new FileInputStream(fileToUpload);
        this.copy(fis, this.archivedIndexOutputStream);
        fis.close();
        this.archivedIndexOutputStream.flush();
        this.archivedIndexOutputStream.closeEntry();
        long end = System.currentTimeMillis();
        this.errorLogger.log("[" + this.currentArchiveFile.getName() + "] Add files to archive: " + logFile.path + " took - " + (end - currentTimestamp) / 1000L + " ms");
    }

    void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }

    @Override
    public void addValueId(long value) {
    }

    @Override
    public void addProbeId(int value) {
    }
}

