/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.perthread;

import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.perthread.ThreadEventCountProvider;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;

class FileEventCountThresholdChecker
implements Runnable {
    private final Map<Integer, OutputStream> threadFileMap;
    private final ThreadEventCountProvider threadEventCountProvider;
    private final Function<Integer, Void> onExpiryRunner;
    private final IErrorLogger errorLogger;

    public FileEventCountThresholdChecker(Map<Integer, OutputStream> threadFileMap, ThreadEventCountProvider threadEventCountProvider, Function<Integer, Void> onExpiryRunner, IErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
        assert (onExpiryRunner != null);
        this.threadEventCountProvider = threadEventCountProvider;
        this.threadFileMap = threadFileMap;
        this.onExpiryRunner = onExpiryRunner;
    }

    @Override
    public void run() {
        Integer[] keySet;
        for (Integer theThreadId : keySet = this.threadFileMap.keySet().toArray(new Integer[0])) {
            int eventCount = this.threadEventCountProvider.getThreadEventCount(theThreadId).get();
            if (eventCount <= 0) continue;
            this.onExpiryRunner.apply(theThreadId);
        }
    }

    public void shutdown() {
        Integer[] keySet;
        for (Integer theThreadId : keySet = this.threadFileMap.keySet().toArray(new Integer[0])) {
            int eventCount = this.threadEventCountProvider.getThreadEventCount(theThreadId).get();
            this.onExpiryRunner.apply(theThreadId);
        }
    }
}

