/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.util.FileNameGenerator;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class EventDataStream {
    public static final int MAX_EVENTS_PER_FILE = 10000000;
    public static final int BYTES_PER_EVENT = 16;
    private FileNameGenerator files;
    private DataOutputStream out;
    private IErrorLogger err;
    private int count;
    private static final AtomicInteger nextThreadId = new AtomicInteger(0);
    private static ThreadLocal<Integer> threadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return nextThreadId.getAndIncrement();
        }
    };

    public EventDataStream(FileNameGenerator target, IErrorLogger logger) {
        try {
            this.files = target;
            this.err = logger;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(target.getNextFile()), 32768));
            this.count = 0;
        }
        catch (IOException e) {
            this.err.log(e);
        }
    }

    public synchronized void write(int dataId, long value) {
        if (this.out != null) {
            try {
                if (this.count >= 10000000) {
                    this.out.close();
                    this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.files.getNextFile()), 32768));
                    this.count = 0;
                }
                this.out.writeInt(dataId);
                this.out.writeInt(threadId.get());
                this.out.writeLong(value);
                ++this.count;
            }
            catch (IOException e) {
                this.out = null;
                this.err.log(e);
            }
        }
    }

    public synchronized void close() {
        try {
            this.out.close();
            this.out = null;
        }
        catch (IOException e) {
            this.out = null;
            this.err.log(e);
        }
    }
}

