/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import com.insidious.common.BloomFilterUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import orestes.bloomfilter.BloomFilter;

public class ObjectIdMap {
    public static final int INT_MAP_CAPACITY = 0x100000;
    private final long nextId;
    private final int andKey;
    private final int size;
    private final int INT_MAX_BIT = 30;
    private final int idCount = 0;
    BloomFilter<Integer> aggregatedProbeIdSet;
    private Entry[] entries;
    private int capacity;
    private int threshold;

    public ObjectIdMap(int initialCapacity, File outputDir) throws IOException {
        this.size = 0;
        this.nextId = 1L;
        for (int i = 0; i < 31; ++i) {
            this.capacity = 1 << i;
            if (this.capacity > initialCapacity) break;
        }
        this.andKey = -2;
        this.aggregatedProbeIdSet = BloomFilterUtil.newBloomFilterForProbesNonSync(initialCapacity);
    }

    public long getId(Object o) {
        if (o == null) {
            return 0L;
        }
        int hash = System.identityHashCode(o);
        if (this.aggregatedProbeIdSet.contains(hash)) {
            return hash;
        }
        if (this.aggregatedProbeIdSet.getFalsePositiveProbability() > 0.01) {
            System.out.println("Clearing object id bloom filter");
            this.aggregatedProbeIdSet.clear();
        }
        this.aggregatedProbeIdSet.add(hash);
        this.onNewObjectId(o, hash);
        return hash;
    }

    protected void onNewObject(Object o) {
    }

    protected void onNewObjectId(Object o, long id) {
    }

    public int size() {
        return 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public void close() {
    }

    public static class Entry
    implements Serializable {
        private final int hashcode;
        private final long objectId;
        private final WeakReference<Object> reference;
        private final Entry next;

        public Entry(Object o, long id, Entry e, int hashcode) {
            this.reference = new WeakReference<Object>(o);
            this.objectId = id;
            this.next = e;
            this.hashcode = hashcode;
        }
    }
}

