/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import io.unlogged.logging.util.FileNameGenerator;
import io.unlogged.logging.util.StringFileListStream;
import java.io.File;
import java.io.IOException;

public class StringContentFile {
    private StringFileListStream stringList;

    public StringContentFile(File outputDir) throws IOException {
        FileNameGenerator filenames = new FileNameGenerator(outputDir, "LOG$String", ".txt");
        this.stringList = new StringFileListStream(filenames, 100000L, false);
    }

    public void write(long objectId, String content) {
        StringBuilder builder = new StringBuilder(content.length() + 32);
        builder.append(Long.toString(objectId));
        builder.append(",");
        builder.append(Integer.toString(content.length()));
        builder.append(",");
        builder.append("\"");
        JsonStringEncoder.getInstance().quoteAsString(content, builder);
        builder.append("\"");
        builder.append("\n");
        this.stringList.write(builder.toString());
    }

    public void close() {
        this.stringList.close();
    }
}

