/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import io.unlogged.logging.util.TypeIdUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class TypeIdMap {
    public static final int TYPEID_NULL = -1;
    public static final int TYPEID_VOID = 0;
    public static final int TYPEID_BOOLEAN = 1;
    public static final int TYPEID_BYTE = 2;
    public static final int TYPEID_CHAR = 3;
    public static final int TYPEID_DOUBLE = 4;
    public static final int TYPEID_FLOAT = 5;
    public static final int TYPEID_INT = 6;
    public static final int TYPEID_LONG = 7;
    public static final int TYPEID_SHORT = 8;
    public static final int TYPEID_OBJECT = 9;
    private static final Class<?>[] BASIC_TYPE_CLASS = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Object.class, String.class};
    private int nextId;
    private HashMap<Class<?>, String> classToIdMap = new HashMap(65536);
    private ArrayList<String> typeRecords = new ArrayList(65536);
    private static final String SEPARATOR = ",";

    public TypeIdMap() {
        for (int i = 0; i < BASIC_TYPE_CLASS.length; ++i) {
            String id = this.createTypeRecord(BASIC_TYPE_CLASS[i]);
            assert (id.equals(Integer.toString(i)));
        }
    }

    private String createTypeRecord(Class<?> type2) {
        String superClass = this.getTypeIdString(type2.getSuperclass());
        String componentType = this.getTypeIdString(type2.getComponentType());
        String classLocation = this.getClassLocation(type2);
        String id = Integer.toString(this.nextId++);
        this.classToIdMap.put(type2, id);
        StringBuilder record = new StringBuilder(512);
        record.append(id);
        record.append(SEPARATOR);
        record.append(this.getTypeNameFromClass(type2));
        record.append(SEPARATOR);
        record.append(classLocation);
        record.append(SEPARATOR);
        record.append(superClass);
        record.append(SEPARATOR);
        record.append(componentType);
        record.append(SEPARATOR);
        record.append(TypeIdUtil.getClassLoaderIdentifier(type2.getName()));
        this.typeRecords.add(record.toString());
        return id;
    }

    public String getTypeIdString(Class<?> type2) {
        if (type2 == null) {
            return Integer.toString(-1);
        }
        if (this.classToIdMap.containsKey(type2)) {
            return this.classToIdMap.get(type2);
        }
        return this.createTypeRecord(type2);
    }

    private String getTypeNameFromClass(Class<?> type2) {
        if (type2.isArray()) {
            int count = 0;
            while (type2.isArray()) {
                ++count;
                type2 = type2.getComponentType();
            }
            StringBuilder b = new StringBuilder(type2.getName().length() + count * 2);
            b.append(type2.getName());
            for (int i = 0; i < count; ++i) {
                b.append("[]");
            }
            return b.toString();
        }
        return type2.getName();
    }

    private String getClassLocation(Class<?> c) {
        URL resource;
        String name;
        ClassLoader loader = c.getClassLoader();
        if (loader == null) {
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
        }
        if (loader != null && (name = c.getName()) != null && (resource = loader.getResource(name.replace(".", "/") + ".class")) != null) {
            return resource.toString();
        }
        return "";
    }

    public void save(File f) {
        try {
            FileWriter fileWriter = new FileWriter(f);
            PrintWriter writer = new PrintWriter(fileWriter);
            for (int i = 0; i < this.typeRecords.size(); ++i) {
                writer.println(this.typeRecords.get(i));
            }
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isPrimitiveTypeOrNull(int typeId) {
        switch (typeId) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

