/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.util;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassTypeUtil {
    public static List<String> splitMethodDesc(String desc) {
        int beginIndex = desc.indexOf(40);
        int endIndex = desc.lastIndexOf(41);
        if (beginIndex == -1 && endIndex != -1 || beginIndex != -1 && endIndex == -1) {
            System.err.println(beginIndex);
            System.err.println(endIndex);
            throw new RuntimeException();
        }
        String x0 = beginIndex == -1 && endIndex == -1 ? desc : desc.substring(beginIndex + 1, endIndex);
        Pattern pattern = Pattern.compile("\\[*L[^;]+;|\\[[ZBCSIFDJ]|[ZBCSIFDJ]");
        Matcher matcher = pattern.matcher(x0);
        LinkedList<String> listMatches = new LinkedList<String>();
        while (matcher.find()) {
            listMatches.add(matcher.group());
        }
        listMatches.add(desc.substring(endIndex + 1));
        return listMatches;
    }

    public static Class<?> getClassNameFromDescriptor(String descriptor2, ClassLoader targetClassLoader) {
        char firstChar = descriptor2.charAt(0);
        switch (firstChar) {
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return targetClassLoader.loadClass(descriptor2.substring(1, descriptor2.length() - 1).replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (descriptor2.startsWith("byte")) {
            return Byte.TYPE;
        }
        if (descriptor2.startsWith("boolean")) {
            return Boolean.TYPE;
        }
        if (descriptor2.startsWith("long")) {
            return Long.TYPE;
        }
        if (descriptor2.startsWith("float")) {
            return Float.TYPE;
        }
        if (descriptor2.startsWith("short")) {
            return Short.TYPE;
        }
        if (descriptor2.startsWith("int")) {
            return Integer.TYPE;
        }
        if (descriptor2.startsWith("double")) {
            return Double.TYPE;
        }
        if (descriptor2.startsWith("void")) {
            return Void.TYPE;
        }
        if (descriptor2.startsWith("char")) {
            return Character.TYPE;
        }
        return null;
    }
}

