/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.weaver;

import com.insidious.common.weaver.EventType;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class DataInfoProvider {
    private final AtomicInteger classId;
    private final AtomicInteger methodId;
    private final AtomicInteger probeId;
    private OutputStream probeOutputStream;
    private File idsInfoOutputFile;

    public DataInfoProvider(int classId, int methodId, int probeId) {
        this.classId = new AtomicInteger(classId);
        this.methodId = new AtomicInteger(methodId);
        this.probeId = new AtomicInteger(probeId);
    }

    public int nextClassId() {
        return this.classId.addAndGet(1);
    }

    public int nextMethodId() {
        return this.methodId.addAndGet(1);
    }

    public int nextProbeId(EventType eventType) {
        int nextProbeId = this.probeId.addAndGet(1);
        if (eventType.equals((Object)EventType.CALL_PARAM) || eventType.equals((Object)EventType.METHOD_PARAM) || eventType.equals((Object)EventType.CALL_RETURN) || eventType.equals((Object)EventType.METHOD_NORMAL_EXIT) || eventType.equals((Object)EventType.METHOD_EXCEPTIONAL_EXIT)) {
            byte[] buffer = new byte[]{(byte)(nextProbeId >>> 24), (byte)(nextProbeId >>> 16), (byte)(nextProbeId >>> 8), (byte)(nextProbeId >>> 0)};
            try {
                this.probeOutputStream.write(buffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return nextProbeId;
    }

    public OutputStream getProbeOutputStream() {
        return this.probeOutputStream;
    }

    public void setProbeOutputStream(OutputStream probeOutputStream) {
        this.probeOutputStream = probeOutputStream;
    }

    public void setIdsInfoFile(File idsInfoOutputFile) {
        this.idsInfoOutputFile = idsInfoOutputFile;
    }

    public void flushIdInformation() throws IOException {
        DataOutputStream infoWriter = new DataOutputStream(new FileOutputStream(this.idsInfoOutputFile));
        infoWriter.writeInt(this.classId.get());
        infoWriter.writeInt(this.methodId.get());
        infoWriter.writeInt(this.probeId.get());
    }
}

