/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.weaver;

import com.insidious.common.weaver.ClassInfo;
import com.insidious.common.weaver.DataInfo;
import com.insidious.common.weaver.MethodInfo;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import io.unlogged.core.TypeLibrary;
import io.unlogged.core.TypeResolver;
import io.unlogged.core.UnloggedNode;
import io.unlogged.core.handlers.JavacHandlerUtil;
import io.unlogged.core.javac.JavacASTAdapter;
import io.unlogged.core.javac.JavacNode;
import io.unlogged.core.javac.JavacTreeMaker;
import io.unlogged.weaver.MethodCallInformation;
import io.unlogged.weaver.TypeHierarchy;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class UnloggedVisitor
extends JavacASTAdapter {
    private final Map<String, Boolean> methodRoots = new HashMap<String, Boolean>();
    private final Map<JCTree.JCClassDecl, ClassInfo> classRoots = new HashMap<JCTree.JCClassDecl, ClassInfo>();
    private final Map<JCTree.JCClassDecl, JCTree.JCCompilationUnit> classToCompilationRoots = new HashMap<JCTree.JCClassDecl, JCTree.JCCompilationUnit>();
    private final Map<ClassInfo, JavacNode> classJavacNodeMap = new HashMap<ClassInfo, JavacNode>();
    private final Map<ClassInfo, java.util.List<MethodInfo>> classMethodInfoList = new HashMap<ClassInfo, java.util.List<MethodInfo>>();
    private final Map<ClassInfo, java.util.List<DataInfo>> classDataInfoList = new HashMap<ClassInfo, java.util.List<DataInfo>>();
    private final TypeLibrary typeLibrary = new TypeLibrary();
    private final Random random = new Random();
    private final TypeHierarchy typeHierarchy;
    private int currentClassId;
    private int currentMethodId;
    private int currentLineNumber;

    public UnloggedVisitor(TypeHierarchy typeHierarchy) {
        this.typeHierarchy = typeHierarchy;
    }

    public void visitType(JavacNode typeNode, JCTree.JCClassDecl type2) {
        TypeResolver typeResolver = new TypeResolver(((JavacNode)typeNode.top()).getImportList());
        java.util.List interfaceClauseList = type2.getImplementsClause();
        String[] interfaceNames = new String[]{};
        if (interfaceClauseList != null && ((List)interfaceClauseList).size() > 0) {
            interfaceNames = new String[((List)interfaceClauseList).size()];
            for (int i = 0; i < ((List)interfaceClauseList).size(); ++i) {
                String interfaceName;
                JCTree.JCExpression jcExpression = (JCTree.JCExpression)((List)interfaceClauseList).get(i);
                interfaceNames[i] = interfaceName = this.getQualifiedTypeName(typeNode, typeResolver, jcExpression);
            }
        }
        String superClassName = "";
        if (type2.getExtendsClause() != null) {
            superClassName = this.getQualifiedTypeName(typeNode, typeResolver, type2.getExtendsClause());
        }
        String typeName = typeNode.getName();
        String qualifiedTypeName = this.qualifiedNameFromString(typeNode, typeResolver, typeName);
        this.typeHierarchy.registerClass(qualifiedTypeName, superClassName, interfaceNames);
        super.visitType(typeNode, type2);
    }

    @NotNull
    private String getQualifiedTypeName(JavacNode typeNode, TypeResolver typeResolver, JCTree.JCExpression typeExpression) {
        String typeName = typeExpression.toString();
        if (typeExpression instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply appliedType = (JCTree.JCTypeApply)typeExpression;
            typeName = appliedType.getType().toString();
        } else if (!(typeExpression instanceof JCTree.JCIdent)) {
            if (typeExpression instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)typeExpression;
                typeName = fieldAccess.toString();
            } else {
                System.err.println("Expression is not a JCTypeApply: " + typeExpression.getClass());
            }
        }
        return this.qualifiedNameFromString(typeNode, typeResolver, typeName);
    }

    @NotNull
    private String qualifiedNameFromString(JavacNode typeNode, TypeResolver typeResolver, String typeName) {
        String qualifiedTypeName = typeResolver.typeRefToFullyQualifiedName((UnloggedNode)typeNode, this.typeLibrary, typeName);
        if (qualifiedTypeName == null) {
            qualifiedTypeName = typeNode.getPackageDeclaration() + "." + typeName;
        }
        return qualifiedTypeName;
    }

    public void visitCompilationUnit(JavacNode top, JCTree.JCCompilationUnit unit) {
        for (JCTree.JCImport anImport : unit.getImports()) {
            this.typeLibrary.addType(((JCTree)anImport.getQualifiedIdentifier()).toString());
        }
    }

    public Map<JCTree.JCClassDecl, JCTree.JCCompilationUnit> getClassToCompilationRoots() {
        return this.classToCompilationRoots;
    }

    public void visitMethod(JavacNode methodNode, JCTree.JCMethodDecl jcMethodDecl) {
    }

    private int getPositionToLine(JavacNode classNode, int startPosition) {
        String codeString = ((JCTree)classNode.get()).getTree().toString();
        if (startPosition > codeString.length()) {
            return 0;
        }
        codeString = codeString.substring(0, startPosition);
        return codeString.split("\\n").length;
    }

    private MethodCallInformation getMethodInformation(JCTree.JCExpression methodSelect) {
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)methodSelect;
            String subject = fieldAccess.getExpression().toString();
            String methodName = fieldAccess.getIdentifier().toString();
            return new MethodCallInformation(subject, methodName);
        }
        return null;
    }

    private JCTree.JCExpressionStatement createLogStatement(JavacNode methodNode, JCTree.JCExpression ident, int dataId) {
        JavacTreeMaker treeMaker = methodNode.getTreeMaker();
        JCTree.JCExpression printlnMethod = JavacHandlerUtil.chainDotsString((JavacNode)methodNode, (String)"io.unlogged.logging.Logging.recordEvent");
        return treeMaker.Exec((JCTree.JCExpression)treeMaker.Apply(List.nil(), printlnMethod, List.of(ident, treeMaker.Literal((Object)dataId))));
    }

    private String createMethodDescriptor(JavacNode methodNode) {
        return "(IL)Ljava.lang.Integer;";
    }

    public Map<JCTree.JCClassDecl, ClassInfo> getClassRoots() {
        return this.classRoots;
    }

    public Map<ClassInfo, JavacNode> getClassNodeMap() {
        return this.classJavacNodeMap;
    }

    public Map<ClassInfo, java.util.List<MethodInfo>> getMethodMap() {
        return this.classMethodInfoList;
    }

    public Map<ClassInfo, java.util.List<DataInfo>> getClassDataInfoList() {
        return this.classDataInfoList;
    }
}

