/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.weaver;

import com.insidious.common.weaver.DataInfo;
import com.insidious.common.weaver.Descriptor;
import com.insidious.common.weaver.EventType;
import com.insidious.common.weaver.MethodInfo;
import io.unlogged.weaver.DataInfoProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class WeaveLog {
    public static final String SEPARATOR = ",";
    private final int classId;
    private final DataInfoProvider dataInfoProvider;
    private final ArrayList<DataInfo> dataEntries;
    private final ArrayList<MethodInfo> methodEntries;
    private final StringWriter logger;
    private final PrintWriter loggerWrapper;
    private String fullClassName;
    private int methodId;

    public WeaveLog(int classId, DataInfoProvider dataInfoProvider) {
        this.classId = classId;
        this.dataInfoProvider = dataInfoProvider;
        this.dataEntries = new ArrayList();
        this.methodEntries = new ArrayList();
        this.logger = new StringWriter();
        this.loggerWrapper = new PrintWriter(this.logger);
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public void setFullClassName(String name) {
        this.fullClassName = name;
    }

    public void startMethod(String className, String methodName, String methodDesc, int access, String sourceFileName, String methodHash) {
        this.methodId = this.dataInfoProvider.nextMethodId();
        MethodInfo entry = new MethodInfo(this.classId, this.methodId, className, methodName, methodDesc, access, sourceFileName, methodHash);
        this.methodEntries.add(entry);
    }

    public int nextDataId(int line, int instructionIndex, EventType eventType, Descriptor valueDesc, String attributes) {
        int dataId = this.dataInfoProvider.nextProbeId(eventType);
        DataInfo entry = new DataInfo(this.classId, this.methodId, dataId, line, instructionIndex, eventType, valueDesc, attributes);
        this.dataEntries.add(entry);
        return dataId;
    }

    public void log(String message) {
        this.loggerWrapper.println(message);
    }

    public String getLog() {
        this.loggerWrapper.close();
        return this.logger.toString();
    }

    public ArrayList<DataInfo> getDataEntries() {
        return this.dataEntries;
    }

    public ArrayList<MethodInfo> getMethods() {
        return this.methodEntries;
    }
}

