/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import selogger.org.slf4j.Logger;
import selogger.org.slf4j.LoggerFactory;

enum BootClassPath {
    INSTANCE;

    private final Set<String> bootClassPathResources = Collections.unmodifiableSet(BootClassPath.getResourcesOnBootClasspath());

    private static Set<String> getResourcesOnBootClasspath() {
        String[] pathElements;
        Logger logger = LoggerFactory.getLogger(BootClassPath.class);
        HashSet<String> resources = new HashSet<String>();
        String bootClassPath = System.getProperty("sun.boot.class.path", "");
        logger.trace("Boot class-path is: {}", (Object)bootClassPath);
        String pathSeparator = System.getProperty("path.separator");
        logger.trace("Path separator is: '{}'", (Object)pathSeparator);
        for (String pathElement : pathElements = bootClassPath.split(pathSeparator)) {
            resources.addAll(BootClassPath.findResources(Paths.get(pathElement, new String[0]), logger));
        }
        return resources;
    }

    private static Set<String> findResources(Path path, Logger logger) {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return BootClassPath.findResourcesInDirectory(path, logger);
        }
        return BootClassPath.findResourcesInJar(path, logger);
    }

    private static Set<String> findResourcesInJar(Path path, Logger logger) {
        HashSet<String> jarResources = new HashSet<String>();
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                jarResources.add(jarEntry.getName());
            }
        }
        catch (IOException e) {
            logger.warn("Not a jar file: {}", (Object)path);
        }
        return jarResources;
    }

    private static Set<String> findResourcesInDirectory(final Path path, Logger logger) {
        final HashSet<String> dirResources = new HashSet<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        dirResources.add(path.relativize(file).toString());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            logger.warn("Error walking dir: " + path, e);
        }
        return dirResources;
    }

    public final boolean has(String binaryClassName) {
        String resourceClassName = binaryClassName.replace('.', '/').concat(".class");
        return this.bootClassPathResources.contains(resourceClassName);
    }
}

