/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.Function;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.openhft.affinity.impl.Utilities;
import net.openhft.affinity.impl.VersionHelper;
import org.jetbrains.annotations.NotNull;

public class LinuxHelper {
    private static final String LIBRARY_NAME = "c";
    private static final VersionHelper UNKNOWN = new VersionHelper(0, 0, 0);
    private static final VersionHelper VERSION_2_6 = new VersionHelper(2, 6, 0);
    private static final VersionHelper version;

    @NotNull
    public static cpu_set_t sched_getaffinity() {
        CLibrary lib = CLibrary.INSTANCE;
        cpu_set_t cpuset = new cpu_set_t();
        int size = version.isSameOrNewer(VERSION_2_6) ? cpu_set_t.SIZE_OF_CPU_SET_T : NativeLong.SIZE;
        try {
            if (lib.sched_getaffinity(0, size, cpuset) != 0) {
                throw new IllegalStateException("sched_getaffinity(0, " + size + ", cpuset) failed; errno=" + Native.getLastError());
            }
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getaffinity(0, (" + size + ") , cpuset) failed; errno=" + e.getErrorCode(), e);
        }
        return cpuset;
    }

    public static void sched_setaffinity(BitSet affinity) {
        LinuxHelper.sched_setaffinity(0, affinity);
    }

    public static void sched_setaffinity(int pid, BitSet affinity) {
        CLibrary lib = CLibrary.INSTANCE;
        cpu_set_t cpuset = new cpu_set_t();
        int size = version.isSameOrNewer(VERSION_2_6) ? cpu_set_t.SIZE_OF_CPU_SET_T : NativeLong.SIZE;
        long[] bits = affinity.toLongArray();
        for (int i = 0; i < bits.length; ++i) {
            if (Platform.is64Bit()) {
                cpuset.__bits[i].setValue(bits[i]);
                continue;
            }
            cpuset.__bits[i * 2].setValue(bits[i] & 0xFFFFFFFFL);
            cpuset.__bits[i * 2 + 1].setValue(bits[i] >>> 32 & 0xFFFFFFFFL);
        }
        try {
            if (lib.sched_setaffinity(pid, size, cpuset) != 0) {
                throw new IllegalStateException("sched_setaffinity(" + pid + ", " + size + ", 0x" + Utilities.toHexString(affinity) + ") failed; errno=" + Native.getLastError());
            }
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_setaffinity(" + pid + ", " + size + ", 0x" + Utilities.toHexString(affinity) + ") failed; errno=" + e.getErrorCode(), e);
        }
    }

    public static int sched_getcpu() {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.sched_getcpu();
            if (ret < 0) {
                throw new IllegalStateException("sched_getcpu() failed; errno=" + Native.getLastError());
            }
            return ret;
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getcpu() failed; errno=" + e.getErrorCode(), e);
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                IntByReference cpu = new IntByReference();
                IntByReference node = new IntByReference();
                int ret = lib.syscall(318, cpu, node, null);
                if (ret != 0) {
                    throw new IllegalStateException("getcpu() failed; errno=" + Native.getLastError());
                }
                return cpu.getValue();
            }
            catch (LastErrorException lee) {
                if (lee.getErrorCode() == 38 && Platform.is64Bit()) {
                    IntByReference cpu;
                    Pointer getcpuAddr = new Pointer(-10483712L);
                    Function getcpu = Function.getFunction(getcpuAddr, 0);
                    if (getcpu.invokeInt(new Object[]{cpu = new IntByReference(), null, null}) < 0) {
                        throw new IllegalStateException("getcpu() failed; errno=" + Native.getLastError());
                    }
                    return cpu.getValue();
                }
                throw new IllegalStateException("getcpu() failed; errno=" + lee.getErrorCode(), lee);
            }
        }
    }

    public static int getpid() {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.getpid();
            if (ret < 0) {
                throw new IllegalStateException("getpid() failed; errno=" + Native.getLastError());
            }
            return ret;
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("getpid() failed; errno=" + e.getErrorCode(), e);
        }
    }

    public static int syscall(int number, Object ... args2) {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.syscall(number, args2);
            if (ret < 0) {
                throw new IllegalStateException("sched_getcpu() failed; errno=" + Native.getLastError());
            }
            return ret;
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getcpu() failed; errno=" + e.getErrorCode(), e);
        }
    }

    static {
        utsname uname = new utsname();
        VersionHelper ver = UNKNOWN;
        try {
            if (CLibrary.INSTANCE.uname(uname) == 0) {
                ver = new VersionHelper(uname.getRealeaseVersion());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        version = ver;
    }

    public static class cpu_set_t
    extends Structure {
        static final int __CPU_SETSIZE = 1024;
        static final int __NCPUBITS = 8 * NativeLong.SIZE;
        static final int SIZE_OF_CPU_SET_T = 1024 / __NCPUBITS * NativeLong.SIZE;
        static List<String> FIELD_ORDER = Collections.singletonList("__bits");
        public NativeLong[] __bits = new NativeLong[1024 / __NCPUBITS];

        public cpu_set_t() {
            for (int i = 0; i < this.__bits.length; ++i) {
                this.__bits[i] = new NativeLong(0L);
            }
        }

        public static void __CPU_ZERO(cpu_set_t cpuset) {
            for (NativeLong bits : cpuset.__bits) {
                bits.setValue(0L);
            }
        }

        public static int __CPUELT(int cpu) {
            return cpu / __NCPUBITS;
        }

        public static long __CPUMASK(int cpu) {
            return 1L << cpu % __NCPUBITS;
        }

        public static void __CPU_SET(int cpu, cpu_set_t cpuset) {
            cpuset.__bits[cpu_set_t.__CPUELT(cpu)].setValue(cpuset.__bits[cpu_set_t.__CPUELT(cpu)].longValue() | cpu_set_t.__CPUMASK(cpu));
        }

        public static void __CPU_CLR(int cpu, cpu_set_t cpuset) {
            cpuset.__bits[cpu_set_t.__CPUELT(cpu)].setValue(cpuset.__bits[cpu_set_t.__CPUELT(cpu)].longValue() & (cpu_set_t.__CPUMASK(cpu) ^ 0xFFFFFFFFFFFFFFFFL));
        }

        public static boolean __CPU_ISSET(int cpu, cpu_set_t cpuset) {
            return (cpuset.__bits[cpu_set_t.__CPUELT(cpu)].longValue() & cpu_set_t.__CPUMASK(cpu)) != 0L;
        }

        protected List getFieldOrder() {
            return FIELD_ORDER;
        }
    }

    public static class utsname
    extends Structure {
        public static final int _UTSNAME_LENGTH = 65;
        static List<String> FIELD_ORDER = Arrays.asList("sysname", "nodename", "release", "version", "machine", "domainname");
        public byte[] sysname = new byte[65];
        public byte[] nodename = new byte[65];
        public byte[] release = new byte[65];
        public byte[] version = new byte[65];
        public byte[] machine = new byte[65];
        public byte[] domainname = new byte[65];

        static int length(byte[] data2) {
            int len;
            int datalen = data2.length;
            for (len = 0; len < datalen && data2[len] != 0; ++len) {
            }
            return len;
        }

        protected List getFieldOrder() {
            return FIELD_ORDER;
        }

        public String getSysname() {
            return new String(this.sysname, 0, utsname.length(this.sysname));
        }

        public String getNodename() {
            return new String(this.nodename, 0, utsname.length(this.nodename));
        }

        public String getRelease() {
            return new String(this.release, 0, utsname.length(this.release));
        }

        public String getRealeaseVersion() {
            char c;
            int len;
            String release = this.getRelease();
            int releaseLen = release.length();
            for (len = 0; len < releaseLen && (Character.isDigit(c = release.charAt(len)) || c == '.'); ++len) {
            }
            return release.substring(0, len);
        }

        public String getVersion() {
            return new String(this.version, 0, utsname.length(this.version));
        }

        public String getMachine() {
            return new String(this.machine, 0, utsname.length(this.machine));
        }

        public String getDomainname() {
            return new String(this.domainname, 0, utsname.length(this.domainname));
        }

        @Override
        public String toString() {
            return this.getSysname() + " " + this.getRelease() + " " + this.getVersion() + " " + this.getMachine();
        }
    }

    static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = Native.load("c", CLibrary.class);

        public int sched_setaffinity(int var1, int var2, cpu_set_t var3) throws LastErrorException;

        public int sched_getaffinity(int var1, int var2, cpu_set_t var3) throws LastErrorException;

        public int getpid() throws LastErrorException;

        public int sched_getcpu() throws LastErrorException;

        public int uname(utsname var1) throws LastErrorException;

        public int syscall(int var1, Object ... var2) throws LastErrorException;
    }
}

