/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.ByteableIntArrayValues;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryIntArrayReference
extends AbstractReference
implements ByteableIntArrayValues,
BytesMarshallable {
    public static final int SHIFT = 2;
    private static final long CAPACITY = 0L;
    private static final long USED = 8L;
    private static final long VALUES = 16L;
    private static final int MAX_TO_STRING = 1024;
    @Nullable
    private static Set<WeakReference<BinaryIntArrayReference>> binaryIntArrayReferences = null;
    private long length;

    public BinaryIntArrayReference() {
        this(0L);
    }

    public BinaryIntArrayReference(long defaultCapacity) {
        this.length = (defaultCapacity << 2) + 16L;
    }

    public static void startCollecting() {
        binaryIntArrayReferences = Collections.newSetFromMap(new IdentityHashMap());
    }

    public static void forceAllToNotCompleteState() throws IllegalStateException, BufferOverflowException {
        if (binaryIntArrayReferences == null) {
            return;
        }
        for (WeakReference<BinaryIntArrayReference> x : binaryIntArrayReferences) {
            @Nullable BinaryIntArrayReference binaryLongReference = (BinaryIntArrayReference)x.get();
            if (binaryLongReference == null) continue;
            binaryLongReference.setValueAt(0L, Integer.MIN_VALUE);
        }
        binaryIntArrayReferences = null;
    }

    public static void write(@NotNull Bytes bytes, long capacity) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        long start = bytes.writePosition();
        bytes.zeroOut(start, start + (capacity << 2));
        bytes.writeSkip(capacity << 2);
    }

    public static void lazyWrite(@NotNull Bytes bytes, long capacity) throws BufferOverflowException, IllegalStateException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        bytes.writeSkip(capacity << 2);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) throws BufferUnderflowException, IllegalStateException {
        long capacity = bytes.readLong(offset + 0L);
        assert (capacity > 0L) : "capacity too small " + capacity;
        return (capacity << 2) + 16L;
    }

    @Override
    protected void acceptNewBytesStore(@NotNull BytesStore bytes) throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = bytes;
        this.bytes.reserve(this);
    }

    @Override
    public long getCapacity() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.length - 16L >>> 2;
    }

    @Override
    public long getUsed() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileInt(this.offset + 8L);
    }

    @Override
    public void setMaxUsed(long usedAtLeast) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeMaxLong(this.offset + 8L, usedAtLeast);
    }

    @Override
    public int getValueAt(long index) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes.readInt(16L + this.offset + (index << 2));
    }

    @Override
    public void setValueAt(long index, int value) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeInt(16L + this.offset + (index << 2), value);
    }

    @Override
    public int getVolatileValueAt(long index) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileInt(16L + this.offset + (index << 2));
    }

    @Override
    public void bindValueAt(long index, @NotNull IntValue value) throws IllegalStateException, BufferOverflowException, IllegalArgumentException {
        this.throwExceptionIfClosed();
        ((BinaryIntReference)value).bytesStore(this.bytes, 16L + this.offset + (index << 2), 8L);
    }

    @Override
    public void setOrderedValueAt(long index, int value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeOrderedInt(16L + this.offset + (index << 2), value);
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalArgumentException, IllegalStateException, BufferOverflowException {
        long peakLength;
        this.throwExceptionIfClosed();
        try {
            peakLength = BinaryIntArrayReference.peakLength(bytes, offset);
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        if (length != peakLength) {
            throw new IllegalArgumentException(length + " != " + peakLength);
        }
        assert ((offset & 7L) == 0L) : "offset=" + offset;
        super.bytesStore(bytes, offset + 7L & 0xFFFFFFFFFFFFFFF8L, length);
        this.length = length;
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        long position = bytes.readPosition();
        long capacity = bytes.readLong();
        long used = bytes.readLong();
        if (capacity < 0L || capacity > bytes.readRemaining() >> 2) {
            throw new IORuntimeException("Corrupt used capacity");
        }
        if (used < 0L || used > capacity) {
            throw new IORuntimeException("Corrupt used value");
        }
        bytes.readSkip(capacity << 2);
        long length = bytes.readPosition() - position;
        try {
            this.bytesStore((BytesStore)((Bytes)bytes), position, length);
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException {
        BytesStore bytesStore = this.bytesStore();
        if (bytesStore == null) {
            long capacity = this.getCapacity();
            bytes.writeLong(capacity);
            bytes.writeLong(0L);
            bytes.writeSkip(capacity << 2);
        } else {
            try {
                bytes.write(bytesStore, this.offset, this.length);
            }
            catch (IllegalArgumentException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public boolean isNull() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.bytes == null;
    }

    @Override
    public void reset() throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "not set";
        }
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("used: ");
        try {
            long used = this.getUsed();
            sb.append(used);
            sb.append(", value: ");
            @NotNull String sep = "";
            try {
                int i;
                int max = (int)Math.min(used, Math.min(this.getCapacity(), 1024L));
                for (i = 0; i < max; ++i) {
                    long valueAt = this.getValueAt(i);
                    sb.append(sep).append(valueAt);
                    sep = ", ";
                }
                if ((long)i < this.getCapacity()) {
                    sb.append(" ...");
                }
            }
            catch (BufferUnderflowException e) {
                sb.append(" ").append(e);
            }
            return sb.toString();
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long sizeInBytes(long capacity) throws IllegalStateException {
        this.throwExceptionIfClosed();
        return (capacity << 2) + 16L;
    }

    @Override
    public ByteableIntArrayValues capacity(long arrayLength) throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        BytesStore bytesStore = this.bytesStore();
        long length = this.sizeInBytes(arrayLength);
        if (bytesStore == null) {
            this.length = length;
        } else assert (this.length == length);
        return this;
    }

    @Override
    public boolean compareAndSet(long index, int expected, int value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (value == Integer.MIN_VALUE && binaryIntArrayReferences != null) {
            binaryIntArrayReferences.add(new WeakReference<BinaryIntArrayReference>(this));
        }
        return this.bytes.compareAndSwapInt(16L + this.offset + (index << 2), expected, value);
    }
}

