/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.ByteableLongArrayValues;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryLongArrayReference
extends AbstractReference
implements ByteableLongArrayValues,
BytesMarshallable {
    public static final int SHIFT = 3;
    private static final long CAPACITY = 0L;
    private static final long USED = 8L;
    private static final long VALUES = 16L;
    private static final int MAX_TO_STRING = 1024;
    @Nullable
    private static Set<WeakReference<BinaryLongArrayReference>> binaryLongArrayReferences = null;
    private long length;

    public BinaryLongArrayReference() {
        this(0L);
    }

    public BinaryLongArrayReference(long defaultCapacity) {
        this.length = (defaultCapacity << 3) + 16L;
    }

    public static void startCollecting() {
        binaryLongArrayReferences = Collections.newSetFromMap(new IdentityHashMap());
    }

    public static void forceAllToNotCompleteState() throws IllegalStateException, BufferOverflowException {
        if (binaryLongArrayReferences == null) {
            return;
        }
        for (WeakReference<BinaryLongArrayReference> x : binaryLongArrayReferences) {
            @Nullable BinaryLongArrayReference binaryLongReference = (BinaryLongArrayReference)x.get();
            if (binaryLongReference == null) continue;
            binaryLongReference.setValueAt(0L, -1L);
        }
        binaryLongArrayReferences = null;
    }

    @Override
    protected void acceptNewBytesStore(@NotNull BytesStore bytes) throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = bytes;
        this.bytes.reserve(this);
    }

    public static void write(@NotNull Bytes bytes, long capacity) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        long start = bytes.writePosition();
        bytes.zeroOut(start, start + (capacity << 3));
        bytes.writeSkip(capacity << 3);
    }

    public static void lazyWrite(@NotNull Bytes bytes, long capacity) throws BufferOverflowException, IllegalStateException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        bytes.writeSkip(capacity << 3);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) throws BufferUnderflowException, IllegalStateException {
        long capacity = bytes.readLong(offset + 0L);
        assert (capacity > 0L) : "capacity too small " + capacity;
        return (capacity << 3) + 16L;
    }

    @Override
    public long getCapacity() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.length - 16L >>> 3;
    }

    @Override
    public long getUsed() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileLong(this.offset + 8L);
    }

    @Override
    public void setMaxUsed(long usedAtLeast) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeMaxLong(this.offset + 8L, usedAtLeast);
    }

    @Override
    public long getValueAt(long index) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this.bytes.readLong(16L + this.offset + (index << 3));
    }

    @Override
    public void setValueAt(long index, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeLong(16L + this.offset + (index << 3), value);
    }

    @Override
    public long getVolatileValueAt(long index) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileLong(16L + this.offset + (index << 3));
    }

    @Override
    public void bindValueAt(long index, @NotNull LongValue value) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        try {
            ((BinaryLongReference)value).bytesStore(this.bytes, 16L + this.offset + (index << 3), 8L);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setOrderedValueAt(long index, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeOrderedLong(16L + this.offset + (index << 3), value);
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalArgumentException, IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = bytes.bytesStore();
        try {
            long peakLength = BinaryLongArrayReference.peakLength(bytesStore, offset);
            if (length != peakLength) {
                throw new IllegalArgumentException(length + " != " + peakLength);
            }
        }
        catch (BufferUnderflowException e) {
            throw new DecoratedBufferOverflowException(e.toString());
        }
        assert ((offset & 7L) == 0L) : "offset=" + offset;
        super.bytesStore(bytesStore, offset + 7L & 0xFFFFFFFFFFFFFFF8L, length);
        this.length = length;
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        long position = bytes.readPosition();
        long capacity = bytes.readLong();
        long used = bytes.readLong();
        if (capacity < 0L || capacity > bytes.readRemaining() >> 3) {
            throw new IORuntimeException("Corrupt used capacity");
        }
        if (used < 0L || used > capacity) {
            throw new IORuntimeException("Corrupt used value");
        }
        bytes.readSkip(capacity << 3);
        long length = bytes.readPosition() - position;
        try {
            this.bytesStore((BytesStore)((Bytes)bytes), position, length);
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException {
        BytesStore bytesStore = this.bytesStore();
        if (bytesStore == null) {
            long capacity = this.getCapacity();
            bytes.writeLong(capacity);
            bytes.writeLong(0L);
            bytes.writeSkip(capacity << 3);
        } else {
            try {
                bytes.write(bytesStore, this.offset, this.length);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public boolean isNull() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.bytes == null;
    }

    @Override
    public void reset() throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "not set";
        }
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("used: ");
        try {
            int i;
            long used = this.getUsed();
            sb.append(used);
            sb.append(", value: ");
            @NotNull String sep = "";
            int max = (int)Math.min(used, Math.min(this.getCapacity(), 1024L));
            for (i = 0; i < max; ++i) {
                long valueAt = this.getValueAt(i);
                sb.append(sep).append(valueAt);
                sep = ", ";
            }
            if ((long)i < this.getCapacity()) {
                sb.append(" ...");
            }
        }
        catch (Throwable e) {
            sb.append(" ").append(e);
        }
        return sb.toString();
    }

    @Override
    public long sizeInBytes(long capacity) throws IllegalStateException {
        this.throwExceptionIfClosed();
        return (capacity << 3) + 16L;
    }

    @Override
    public ByteableLongArrayValues capacity(long arrayLength) throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        BytesStore bytesStore = this.bytesStore();
        long length = this.sizeInBytes(arrayLength);
        if (bytesStore == null) {
            this.length = length;
        } else assert (this.length == length);
        return this;
    }

    @Override
    public boolean compareAndSet(long index, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (value == -1L && binaryLongArrayReferences != null) {
            binaryLongArrayReferences.add(new WeakReference<BinaryLongArrayReference>(this));
        }
        return this.bytes.compareAndSwapLong(16L + this.offset + (index << 3), expected, value);
    }
}

