/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.BytesUtil;
import org.jetbrains.annotations.NotNull;

public enum PropertyReplacer {

    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{\\s*([^}]*?)\\s*\\}");

    public static String replaceTokensWithProperties(String expression) throws IllegalArgumentException {
        StringBuilder result2 = new StringBuilder(expression.length());
        int i = 0;
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        while (matcher.find()) {
            result2.append(expression, i, matcher.start());
            String property = matcher.group(1);
            String p = System.getProperty(property);
            if (p == null) {
                throw new IllegalArgumentException(String.format("System property is missing: [property=%s, expression=%s]", property, expression));
            }
            result2.append(p);
            i = matcher.end();
        }
        result2.append(expression.substring(i));
        return result2.toString();
    }

    public static String replaceTokensWithProperties(String expression, Properties properties2) throws IllegalArgumentException {
        StringBuilder result2 = new StringBuilder(expression.length());
        int i = 0;
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        while (matcher.find()) {
            result2.append(expression, i, matcher.start());
            String property = matcher.group(1);
            String p = properties2.getProperty(property);
            if (p == null) {
                throw new IllegalArgumentException(String.format("Property is missing: [property=%s, expression=%s, properties=%s]", property, expression, properties2));
            }
            result2.append(p);
            i = matcher.end();
        }
        result2.append(expression.substring(i));
        return result2.toString();
    }

    @Deprecated
    @NotNull
    public static String fileAsString(String fileName) throws IOException {
        try {
            Class<PropertyReplacer> propertyReplacerClass = PropertyReplacer.class;
            InputStream is = propertyReplacerClass.getResourceAsStream(fileName);
            if (is != null) {
                return PropertyReplacer.convertStreamToString(is);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BytesUtil.readFile(fileName).toString();
    }

    @NotNull
    private static String convertStreamToString(@NotNull InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

