/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import org.jetbrains.annotations.NotNull;

public enum Mocker {

    private static final Class[] NO_CLASSES = new Class[0];

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description2, @NotNull PrintStream out) {
        return Mocker.intercepting(tClass, description2, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description2, @NotNull PrintWriter out) {
        return Mocker.intercepting(tClass, description2, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description2, @NotNull StringWriter out) {
        return Mocker.logging(tClass, description2, new PrintWriter(out));
    }

    @NotNull
    public static <T> T queuing(@NotNull Class<T> tClass, String description2, @NotNull BlockingQueue<String> queue) {
        return Mocker.intercepting(tClass, description2, queue::add);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, String description2, @NotNull Consumer<String> consumer) {
        return Mocker.intercepting(tClass, description2, consumer, null);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, @NotNull String description2, @NotNull Consumer<String> consumer, T t) {
        return Mocker.intercepting(tClass, (String name, Object[] args2) -> consumer.accept(description2 + name + (args2 == null ? "()" : Arrays.toString(args2))), t);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, final @NotNull BiConsumer<String, Object[]> consumer, final T t) {
        LinkedHashSet<Class> classes2 = new LinkedHashSet<Class>();
        Mocker.addInterface(classes2, tClass);
        try {
            return (T)Proxy.newProxyInstance(tClass.getClassLoader(), classes2.toArray(NO_CLASSES), (InvocationHandler)new AbstractInvocationHandler(ConcurrentHashMap::new){

                @Override
                protected Object doInvoke(Object proxy, Method method, Object[] args2) throws InvocationTargetException, IllegalAccessException {
                    consumer.accept(method.getName(), args2);
                    try {
                        if (t != null) {
                            return method.invoke(t, args2);
                        }
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <T> void addInterface(Set<Class> classes2, Class<T> tClass) {
        if (Jvm.dontChain(tClass)) {
            return;
        }
        if (classes2.contains(tClass)) {
            return;
        }
        classes2.add(tClass);
        for (Method method : tClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!returnType.isInterface()) continue;
            Mocker.addInterface(classes2, returnType);
        }
    }

    @NotNull
    public static <T> T ignored(@NotNull Class<T> tClass, Class ... additional) {
        LinkedHashSet<Class> classes2 = new LinkedHashSet<Class>();
        Mocker.addInterface(classes2, tClass);
        for (Class aClass : additional) {
            Mocker.addInterface(classes2, aClass);
        }
        try {
            return (T)Proxy.newProxyInstance(tClass.getClassLoader(), classes2.toArray(NO_CLASSES), (InvocationHandler)new AbstractInvocationHandler(ConcurrentHashMap::new){

                @Override
                protected Object doInvoke(Object proxy, Method method, Object[] args2) throws InvocationTargetException, IllegalAccessException {
                    return null;
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }
}

