/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.pom;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public enum InternalPomProperties {

    private static final Map<String, String> VERSION_CACHE = new ConcurrentHashMap<String, String>();

    @NotNull
    public static Properties create(@NotNull String groupId, @NotNull String artifactId) {
        Properties properties2 = new Properties();
        try {
            String resourceName = InternalPomProperties.resourceName(groupId, artifactId);
            try (InputStream inputStream = InternalPomProperties.class.getResourceAsStream(resourceName);){
                if (inputStream != null) {
                    properties2.load(inputStream);
                }
            }
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        return properties2;
    }

    public static String version(@NotNull String groupId, @NotNull String artifactId) {
        return VERSION_CACHE.computeIfAbsent(groupId + ":" + artifactId, unused -> InternalPomProperties.extractVersionOrUnknown(groupId, artifactId));
    }

    private static String resourceName(@NotNull String groupId, @NotNull String artifactId) {
        return "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
    }

    private static String extractVersionOrUnknown(@NotNull String groupId, @NotNull String artifactId) {
        return InternalPomProperties.create(groupId, artifactId).getProperty("version", "unknown");
    }
}

