/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.CloseableTracer;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public abstract class AbstractCloseable
implements CloseableTracer,
ReferenceOwner,
ManagedCloseable {
    protected static final boolean DISABLE_THREAD_SAFETY = Jvm.getBoolean("disable.thread.safety", false);
    protected static final boolean DISABLE_DISCARD_WARNING = Jvm.getBoolean("disable.discard.warning", false);
    protected static final boolean STRICT_DISCARD_WARNING = Jvm.getBoolean("strict.discard.warning", false);
    @Deprecated
    protected static final boolean CHECK_THREAD_SAFETY = !DISABLE_THREAD_SAFETY;
    protected static final long WARN_NS = (long)(Jvm.getDouble("closeable.warn.secs", 0.02) * 1.0E9);
    private static final long CLOSED_OFFSET;
    private static final int STATE_NOT_CLOSED = 0;
    private static final int STATE_CLOSING = -1;
    private static final int STATE_CLOSED = 1;
    static volatile Set<CloseableTracer> CLOSEABLE_SET;
    private volatile transient int closed = 0;
    private final transient StackTrace createdHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " created here") : null;
    private volatile transient StackTrace closedHere;
    private volatile transient Thread usedByThread;
    private volatile transient StackTrace usedByThreadHere;
    private int referenceId;

    protected AbstractCloseable() {
        Set<CloseableTracer> set = CLOSEABLE_SET;
        if (set != null) {
            set.add(this);
        }
    }

    public static void enableCloseableTracing() {
        CLOSEABLE_SET = Collections.newSetFromMap(new WeakIdentityHashMap());
    }

    public static void disableCloseableTracing() {
        CLOSEABLE_SET = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForCloseablesToClose(long millis) {
        Set<CloseableTracer> traceSet = CLOSEABLE_SET;
        if (traceSet == null) {
            return true;
        }
        long end = System.currentTimeMillis() + millis;
        BackgroundResourceReleaser.releasePendingResources();
        block5: do {
            Set<CloseableTracer> set = traceSet;
            synchronized (set) {
                for (CloseableTracer key : traceSet) {
                    try {
                        if (!(key instanceof ReferenceCountedTracer)) continue;
                        ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                    }
                    catch (IllegalStateException e) {
                        Jvm.pause(1L);
                        continue block5;
                    }
                }
            }
            Jvm.pause(1L);
            return true;
        } while (System.currentTimeMillis() < end);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCloseablesClosed() {
        Set<CloseableTracer> traceSet = CLOSEABLE_SET;
        if (traceSet == null) {
            Jvm.warn().on(AbstractCloseable.class, "closable tracing disabled");
            return;
        }
        BackgroundResourceReleaser.releasePendingResources();
        AssertionError openFiles = new AssertionError((Object)"Closeables still open");
        Set<CloseableTracer> set = traceSet;
        synchronized (set) {
            traceSet.removeIf(o -> o == null || o.isClosing());
            HashSet<CloseableTracer> nested = new HashSet<CloseableTracer>();
            for (CloseableTracer key : traceSet) {
                AbstractCloseable.addNested(nested, key, 1);
            }
            HashSet<CloseableTracer> traceSet2 = new HashSet<CloseableTracer>(traceSet);
            traceSet2.removeAll(nested);
            for (CloseableTracer key : traceSet2) {
                Throwable t;
                try {
                    if (key instanceof ReferenceCountedTracer) {
                        ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                    }
                    t = key.createdHere();
                }
                catch (IllegalStateException e) {
                    t = e;
                }
                IllegalStateException exception = new IllegalStateException("Not closed " + TracingReferenceCounted.asString(key), t);
                Thread.yield();
                if (key.isClosed()) continue;
                exception.printStackTrace();
                ((Throwable)((Object)openFiles)).addSuppressed(exception);
                key.close();
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    private static void addNested(Set<CloseableTracer> nested, CloseableTracer key, int depth) {
        if (key.isClosing()) {
            return;
        }
        HashSet<Field> fields2 = new HashSet<Field>();
        Class<?> keyClass = key.getClass();
        AbstractCloseable.getCloseableFields(keyClass, fields2);
        for (Field field : fields2) {
            try {
                field.setAccessible(true);
                CloseableTracer o = (CloseableTracer)field.get(key);
                if (o == null || !nested.add(o) || depth <= 1) continue;
                AbstractCloseable.addNested(nested, o, depth - 1);
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(keyClass, e);
            }
        }
    }

    private static void getCloseableFields(Class keyClass, Set<Field> fields2) {
        if (keyClass == null || keyClass == Object.class) {
            return;
        }
        for (Field field : keyClass.getDeclaredFields()) {
            if (!CloseableTracer.class.isAssignableFrom(field.getType())) continue;
            fields2.add(field);
        }
        AbstractCloseable.getCloseableFields(keyClass.getSuperclass(), fields2);
    }

    public static void unmonitor(Closeable closeable) {
        if (CLOSEABLE_SET != null) {
            CLOSEABLE_SET.remove(closeable);
        }
    }

    @Override
    public int referenceId() {
        if (this.referenceId == 0) {
            this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        }
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public final void close() {
        if (!UnsafeMemory.INSTANCE.compareAndSwapInt(this, CLOSED_OFFSET, 0, -1)) {
            if (this.shouldWaitForClosed() && this.isInUserThread()) {
                this.waitForClosed();
            }
            return;
        }
        StackTrace stackTrace = this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " closed here") : null;
        if (BackgroundResourceReleaser.BG_RELEASER && this.shouldPerformCloseInBackground()) {
            BackgroundResourceReleaser.release(this);
            return;
        }
        long start = System.nanoTime();
        this.callPerformClose();
        long time = System.nanoTime() - start;
        if (time >= WARN_NS && !BackgroundResourceReleaser.isOnBackgroundResourceReleaserThread()) {
            Jvm.perf().on(this.getClass(), "Took " + time / 1000000L + " ms to performClose");
        }
    }

    protected boolean isInUserThread() {
        return Thread.currentThread().getName().indexOf(126) < 0;
    }

    protected void waitForClosed() {
        long start = System.currentTimeMillis();
        while (this.closed != 1) {
            if (System.currentTimeMillis() > start + 10000L) {
                Jvm.warn().on(this.getClass(), "Aborting close()ing object " + this.referenceId + " after " + (double)(System.currentTimeMillis() - start) / 1000.0 + " secs", new StackTrace("waiting here", this.closedHere));
                break;
            }
            Jvm.pause(1L);
        }
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new ClosedIllegalStateException(this.getClass().getName() + " closed", this.closedHere);
        }
        if (!DISABLE_THREAD_SAFETY) {
            this.threadSafetyCheck(true);
        }
    }

    public void throwExceptionIfClosedInSetter() throws IllegalStateException {
        if (this.isClosed()) {
            throw new ClosedIllegalStateException(this.getClass().getName() + " closed", this.closedHere);
        }
        if (!DISABLE_THREAD_SAFETY) {
            this.threadSafetyCheck(false);
        }
    }

    @Override
    public void warnAndCloseIfNotClosed() {
        if (!this.isClosing()) {
            if (Jvm.isResourceTracing() && !DISABLE_DISCARD_WARNING) {
                ExceptionHandler warn = Jvm.getBoolean("warnAndCloseIfNotClosed") ? Jvm.warn() : Slf4jExceptionHandler.WARN;
                warn.on(this.getClass(), "Discarded without closing", new IllegalStateException(this.createdHere));
            }
            this.close();
        }
    }

    protected abstract void performClose() throws IllegalStateException;

    void callPerformClose() {
        try {
            this.performClose();
        }
        catch (Throwable t) {
            Jvm.debug().on(this.getClass(), t);
        }
        finally {
            this.closed = 1;
        }
    }

    @Override
    public boolean isClosing() {
        return this.closed != 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed == 1;
    }

    protected boolean shouldPerformCloseInBackground() {
        return this.performCloseInBackground();
    }

    @Deprecated
    protected boolean performCloseInBackground() {
        return false;
    }

    protected boolean shouldWaitForClosed() {
        return false;
    }

    protected boolean threadSafetyCheck(boolean isUsed) throws IllegalStateException {
        if (DISABLE_THREAD_SAFETY) {
            return true;
        }
        if (this.usedByThread == null && !isUsed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == null) {
            this.usedByThread = currentThread;
            if (Jvm.isResourceTracing()) {
                this.usedByThreadHere = new StackTrace(this.getClass().getName() + " used here");
            }
        } else if (this.usedByThread != currentThread) {
            if (this.usedByThread.isAlive()) {
                throw new IllegalStateException(this.getClass().getName() + " component which is not thread safes used by " + this.usedByThread + " and " + currentThread, this.usedByThreadHere);
            }
            this.usedByThread = currentThread;
        }
        return true;
    }

    public void resetUsedByThread() {
        this.usedByThread = Thread.currentThread();
        this.usedByThreadHere = new StackTrace(this.getClass().getName() + " used here");
    }

    public void clearUsedByThread() {
        this.usedByThread = null;
        this.usedByThreadHere = null;
    }

    public String toString() {
        return this.referenceName();
    }

    static {
        if (Jvm.isResourceTracing()) {
            AbstractCloseable.enableCloseableTracing();
        }
        CLOSED_OFFSET = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(AbstractCloseable.class, "closed"));
    }
}

