/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.LogLevel;
import org.jetbrains.annotations.NotNull;
import selogger.org.slf4j.Logger;
import selogger.org.slf4j.LoggerFactory;

public enum Slf4jExceptionHandler implements ExceptionHandler
{
    FATAL{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            1.getLogger(clazz).error("FATAL error " + message, thrown);
            if (!Slf4jExceptionHandler.isJUnitTest()) {
                System.exit(-1);
            }
        }
    }
    ,
    ERROR{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            2.getLogger(clazz).error(message, thrown);
        }
    }
    ,
    WARN{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            3.getLogger(clazz).warn(message, thrown);
        }
    }
    ,
    PERF{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            4.getLogger(clazz).info(message, thrown);
        }
    }
    ,
    DEBUG{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            5.getLogger(clazz).debug(message, thrown);
        }

        @Override
        public boolean isEnabled(Class clazz) {
            return 5.getLogger(clazz).isDebugEnabled();
        }
    };

    static final ClassLocal<Logger> CLASS_LOGGER;

    static Logger getLogger(Class clazz) {
        return (Logger)CLASS_LOGGER.get(clazz);
    }

    public static Slf4jExceptionHandler valueOf(LogLevel logLevel) {
        if (logLevel == LogLevel.FATAL) {
            return FATAL;
        }
        if (logLevel == LogLevel.ERROR) {
            return ERROR;
        }
        if (logLevel == LogLevel.WARN) {
            return WARN;
        }
        return DEBUG;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement[] stackTrace : Thread.getAllStackTraces().values()) {
            for (StackTraceElement element : stackTrace) {
                if (!element.getClassName().contains(".junit")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        CLASS_LOGGER = ClassLocal.withInitial(LoggerFactory::getLogger);
    }
}

