/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadLocalHelper {
    private ThreadLocalHelper() {
    }

    @NotNull
    public static <T> T getTL(@NotNull ThreadLocal<WeakReference<T>> threadLocal, @NotNull Supplier<T> supplier) {
        @Nullable WeakReference<Object> ref = threadLocal.get();
        @Nullable T ret = null;
        if (ref != null) {
            ret = ref.get();
        }
        if (ret == null) {
            ret = supplier.get();
            ref = new WeakReference<Object>(ret);
            threadLocal.set(ref);
        }
        return ret;
    }

    @NotNull
    public static <T> T getSTL(@NotNull ThreadLocal<T> threadLocal, @NotNull Supplier<T> supplier) {
        @Nullable T ret = threadLocal.get();
        if (ret == null) {
            ret = supplier.get();
            threadLocal.set(ret);
        }
        return ret;
    }

    @NotNull
    public static <T, A> T getTL(@NotNull ThreadLocal<WeakReference<T>> threadLocal, A a, @NotNull Function<A, T> function) {
        return ThreadLocalHelper.getTL(threadLocal, a, function, null, null);
    }

    @NotNull
    public static <T, A> T getTL(@NotNull ThreadLocal<WeakReference<T>> threadLocal, @NotNull A supplyingEntity, @NotNull Function<A, T> constructor, @Nullable ReferenceQueue<T> referenceQueue, @Nullable Consumer<WeakReference<T>> registrar) {
        @Nullable WeakReference<Object> ref = threadLocal.get();
        Object result2 = null;
        if (ref != null) {
            result2 = ref.get();
        }
        if (result2 == null) {
            result2 = constructor.apply(supplyingEntity);
            if (referenceQueue != null && registrar != null) {
                ref = new WeakReference<Object>(result2, (ReferenceQueue<Object>)referenceQueue);
                registrar.accept(ref);
            } else {
                ref = new WeakReference<Object>(result2);
            }
            threadLocal.set(ref);
        }
        return result2;
    }
}

