/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
extends ThreadGroup
implements ThreadFactory {
    private final AtomicInteger id = new AtomicInteger();
    private final String name;
    private final Boolean daemon;
    private final Integer priority;
    private final StackTrace createdHere;
    private final boolean inEventLoop;

    public NamedThreadFactory(String name) {
        this(name, null, null);
    }

    public NamedThreadFactory(String name, Boolean daemon) {
        this(name, daemon, null);
    }

    public NamedThreadFactory(String name, Boolean daemon, Integer priority) {
        this(name, daemon, priority, false);
    }

    public NamedThreadFactory(String name, Boolean daemon, Integer priority, boolean inEventLoop) {
        super(name);
        this.name = name;
        this.daemon = daemon;
        this.priority = priority;
        this.inEventLoop = inEventLoop;
        this.createdHere = Jvm.isResourceTracing() ? new StackTrace("NamedThreadFactory created here") : null;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        int id = this.id.getAndIncrement();
        String nameN = Threads.threadGroupPrefix() + (id == 0 ? this.name : this.name + '-' + id);
        CleaningThread t = new CleaningThread(r, nameN, this.inEventLoop);
        ThreadDump.add(t, this.createdHere);
        if (this.daemon != null) {
            t.setDaemon(this.daemon);
        }
        if (this.priority != null) {
            t.setPriority(this.priority);
        }
        return t;
    }

    public void interruptAll() {
        Thread[] list = new Thread[this.activeCount() + 1];
        super.enumerate(list);
        for (Thread thread2 : list) {
            if (thread2 == null) continue;
            thread2.interrupt();
        }
    }
}

