/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.text.MessageFormat;

public interface LongConverter {
    public long parse(CharSequence var1);

    public void append(StringBuilder var1, long var2);

    default public String asString(long value) {
        return this.asText(value).toString();
    }

    default public CharSequence asText(long value) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, value);
        return sb;
    }

    default public int maxParseLength() {
        return Integer.MAX_VALUE;
    }

    default public void lengthCheck(CharSequence text) {
        if (text.length() > this.maxParseLength()) {
            throw new IllegalArgumentException(MessageFormat.format("text={0} exceeds the maximum allowable length of {1}", text, this.maxParseLength()));
        }
    }

    public static int maxParseLength(int based) {
        return (int)(64.0 / Math.log(based) * Math.log(2.0));
    }

    public static void main(String[] args2) {
        System.out.println("maxParseLength(85) = " + LongConverter.maxParseLength(85));
    }
}

