/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.ChronicleBitSet;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class LongValueBitSet
extends AbstractCloseable
implements Marshallable,
ChronicleBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private transient Pauser pauser = Pauser.busy();
    private LongValue[] words;
    private transient boolean sizeIsSticky = true;

    public LongValueBitSet(int maxNumberOfBits) {
        int size = maxNumberOfBits / 64 + 1;
        this.words = new LongValue[size];
        this.pauser = Pauser.busy();
    }

    public LongValueBitSet(int maxNumberOfBits, Wire w) {
        this(maxNumberOfBits);
        this.writeMarshallable(w);
        this.readMarshallable(w);
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public static BitSet valueOf(byte[] bytes) {
        return BitSet.valueOf(ByteBuffer.wrap(bytes));
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    @Override
    protected void performClose() {
        Closeable.closeQuietly(this.words);
    }

    private int getWordsInUse() {
        return this.words.length;
    }

    public void set(LongValue word, long param, LongFunction function) {
        long oldValue;
        this.throwExceptionIfClosed();
        Pauser pauser = this.pauser();
        pauser.reset();
        while (!word.compareAndSwapValue(oldValue = word.getVolatileValue(), function.apply(oldValue, param))) {
            pauser.pause();
        }
    }

    private Pauser pauser() {
        if (this.pauser == null) {
            this.pauser = Pauser.busy();
        }
        return this.pauser;
    }

    public void set(LongValue word, long newValue) {
        this.throwExceptionIfClosed();
        this.pauser.reset();
        long oldValue = word.getVolatileValue();
        while (!word.compareAndSwapValue(oldValue, newValue)) {
            this.pauser.pause();
        }
    }

    public byte[] toByteArray() {
        this.throwExceptionIfClosed();
        int n = this.getWordsInUse();
        if (n == 0) {
            return new byte[0];
        }
        int len = 8 * (n - 1);
        for (long x = this.words[n - 1].getValue(); x != 0L; x >>>= 8) {
            ++len;
        }
        byte[] bytes = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n - 1; ++i) {
            bb.putLong(this.words[i].getVolatileValue());
        }
        for (long x = this.words[n - 1].getValue(); x != 0L; x >>>= 8) {
            bb.put((byte)(x & 0xFFL));
        }
        return bytes;
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.getWordsInUse() < wordsRequired) {
            throw new UnsupportedOperationException("todo: it is not possible currently to expand this stucture, because if its concurrent nature and have to implement cross process locking");
        }
    }

    public void flip(int bitIndex) {
        this.throwExceptionIfClosed();
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = LongValueBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.caret(this.words[wordIndex], 1L << bitIndex);
    }

    private void caret(LongValue word, long param) {
        this.set(word, param, (x, y) -> x ^ y);
    }

    private void and(LongValue word, long param) {
        this.set(word, param, (x, y) -> x & y);
    }

    public void flip(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        LongValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = LongValueBitSet.wordIndex(fromIndex);
        int endWordIndex = LongValueBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.caret(this.words[startWordIndex], firstWordMask & lastWordMask);
        } else {
            this.caret(this.words[startWordIndex], firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.caret(this.words[i], -1L);
            }
            this.caret(this.words[endWordIndex], lastWordMask);
        }
    }

    @Override
    public void set(int bitIndex) {
        this.throwExceptionIfClosed();
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = LongValueBitSet.wordIndex(bitIndex);
        this.pipe(this.words[wordIndex], 1L << bitIndex);
    }

    private void pipe(LongValue word, long param) {
        this.set(word, param, (x, y) -> x | y);
    }

    public void set(int bitIndex, boolean value) {
        this.throwExceptionIfClosed();
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        LongValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = LongValueBitSet.wordIndex(fromIndex);
        int endWordIndex = LongValueBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.pipe(this.words[startWordIndex], firstWordMask & lastWordMask);
        } else {
            this.pipe(this.words[startWordIndex], firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.set(this.words[i], -1L, (x, y) -> x);
            }
            this.pipe(this.words[endWordIndex], lastWordMask);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        this.throwExceptionIfClosed();
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        this.throwExceptionIfClosed();
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = LongValueBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.getWordsInUse()) {
            return;
        }
        this.and(this.words[wordIndex], 1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        LongValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = LongValueBitSet.wordIndex(fromIndex);
        if (startWordIndex >= this.getWordsInUse()) {
            return;
        }
        int endWordIndex = LongValueBitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= this.getWordsInUse()) {
            toIndex = this.length();
            endWordIndex = this.getWordsInUse() - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.and(this.words[startWordIndex], firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.and(this.words[startWordIndex], firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].setOrderedValue(0L);
            }
            this.and(this.words[endWordIndex], lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void clear() {
        this.throwExceptionIfClosed();
        int value = this.getWordsInUse();
        while (value > 0) {
            this.words[--value].setValue(0L);
        }
    }

    @Override
    public boolean get(int bitIndex) {
        this.throwExceptionIfClosed();
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = LongValueBitSet.wordIndex(bitIndex);
        return wordIndex < this.getWordsInUse() && (this.words[wordIndex].getValue() & 1L << bitIndex) != 0L;
    }

    public int nextSetBit(int fromIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = LongValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return -1;
        }
        long word = this.words[u].getVolatileValue() & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.getWordsInUse()) {
                return -1;
            }
            word = this.words[u].getVolatileValue();
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int nextSetBit(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = LongValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return -1;
        }
        long word = this.words[u].getVolatileValue() & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.getWordsInUse()) {
                return -1;
            }
            if (u * 64 > toIndex) {
                return -1;
            }
            word = this.words[u].getVolatileValue();
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = LongValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return fromIndex;
        }
        long word = (this.words[u].getVolatileValue() ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.getWordsInUse()) {
                return this.getWordsInUse() * 64;
            }
            word = this.words[u].getValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int previousSetBit(int fromIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = LongValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return this.length() - 1;
        }
        long word = this.words[u].getValue() & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].getValue();
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = LongValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return fromIndex;
        }
        long word = (this.words[u].getVolatileValue() ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].getValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int length() {
        if (this.getWordsInUse() == 0) {
            return 0;
        }
        return 64 * (this.getWordsInUse() - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.getWordsInUse() - 1].getValue()));
    }

    public boolean isEmpty() {
        return this.getWordsInUse() == 0;
    }

    public boolean intersects(LongValueBitSet set) {
        this.throwExceptionIfClosed();
        for (int i = Math.min(this.getWordsInUse(), set.getWordsInUse()) - 1; i >= 0; --i) {
            if ((this.words[i].getVolatileValue() & set.words[i].getVolatileValue()) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        this.throwExceptionIfClosed();
        int sum = 0;
        for (int i = 0; i < this.getWordsInUse(); ++i) {
            sum += Long.bitCount(this.words[i].getVolatileValue());
        }
        return sum;
    }

    public void and(LongValueBitSet set) {
        this.throwExceptionIfClosed();
        if (this == set) {
            return;
        }
        int value = this.getWordsInUse();
        while (this.getWordsInUse() > set.getWordsInUse()) {
            this.words[--value].setValue(0L);
        }
        for (int i = 0; i < this.getWordsInUse(); ++i) {
            this.and(this.words[i], set.words[i].getVolatileValue());
        }
    }

    public void or(LongValueBitSet set) {
        this.throwExceptionIfClosed();
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.getWordsInUse(), set.getWordsInUse());
        for (int i = 0; i < wordsInCommon; ++i) {
            this.pipe(this.words[i], set.words[i].getVolatileValue());
        }
        if (wordsInCommon < set.getWordsInUse()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.getWordsInUse() - wordsInCommon);
        }
    }

    public void xor(LongValueBitSet set) {
        this.throwExceptionIfClosed();
        int wordsInCommon = Math.min(this.getWordsInUse(), set.getWordsInUse());
        for (int i = 0; i < wordsInCommon; ++i) {
            this.caret(this.words[i], set.words[i].getVolatileValue());
        }
        if (wordsInCommon < set.getWordsInUse()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.getWordsInUse() - wordsInCommon);
        }
    }

    public void andNot(LongValueBitSet set) {
        this.throwExceptionIfClosed();
        for (int i = Math.min(this.getWordsInUse(), set.getWordsInUse()) - 1; i >= 0; --i) {
            this.and(this.words[i], set.words[i].getVolatileValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.getWordsInUse();
        while (--i >= 0) {
            h ^= this.words[i].getVolatileValue() * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object obj) {
        this.throwExceptionIfClosed();
        if (!(obj instanceof LongValueBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LongValueBitSet set = (LongValueBitSet)obj;
        if (this.getWordsInUse() != set.getWordsInUse()) {
            return false;
        }
        for (int i = 0; i < this.getWordsInUse(); ++i) {
            if (this.words[i].getVolatileValue() == set.words[i].getVolatileValue()) continue;
            return false;
        }
        return true;
    }

    private void trimToSize() {
        if (this.getWordsInUse() != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.getWordsInUse());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        ObjectOutputStream.PutField fields2 = s.putFields();
        fields2.put("bits", this.words);
        s.writeFields();
    }

    @Override
    public String toString() {
        int numBits = this.getWordsInUse() > 128 ? this.cardinality() : this.getWordsInUse() * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        return b.toString();
    }

    public IntStream stream() {
        this.throwExceptionIfClosed();
        return StreamSupport.intStream(() -> {
            class BitSetIterator
            implements PrimitiveIterator.OfInt {
                int next;

                BitSetIterator() {
                    this.next = LongValueBitSet.this.nextSetBit(0);
                }

                @Override
                public boolean hasNext() {
                    LongValueBitSet.this.throwExceptionIfClosed();
                    return this.next != -1;
                }

                @Override
                public int nextInt() {
                    LongValueBitSet.this.throwExceptionIfClosed();
                    if (this.next != -1) {
                        int ret = this.next;
                        this.next = LongValueBitSet.this.nextSetBit(this.next + 1);
                        return ret;
                    }
                    throw new NoSuchElementException();
                }
            }
            return Spliterators.spliterator(new BitSetIterator(), (long)this.cardinality(), 21);
        }, 16469, false);
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write("numberOfLongValues").int32(this.words.length);
        for (int i = 0; i < this.words.length; ++i) {
            if (this.words[i] == null) {
                this.words[i] = wire.newLongReference();
            }
            wire.getValueOut().int64forBinding(this.words[i].getValue());
        }
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.throwExceptionIfClosed();
        Closeable.closeQuietly(this.words);
        int numberOfLongValues = wire.read("numberOfLongValues").int32();
        this.words = new LongReference[numberOfLongValues];
        for (int i = 0; i < numberOfLongValues; ++i) {
            this.words[i] = wire.getValueIn().int64ForBinding(null);
        }
    }

    static interface LongFunction {
        public long apply(long var1, long var3);
    }
}

