/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.HashProvider;
import orestes.bloomfilter.memory.BloomFilterMemory;
import orestes.bloomfilter.memory.CountingBloomFilter16;
import orestes.bloomfilter.memory.CountingBloomFilter32;
import orestes.bloomfilter.memory.CountingBloomFilter64;
import orestes.bloomfilter.memory.CountingBloomFilter8;
import orestes.bloomfilter.memory.CountingBloomFilterMemory;
import orestes.bloomfilter.redis.BloomFilterRedis;
import orestes.bloomfilter.redis.CountingBloomFilterRedis;
import orestes.bloomfilter.redis.helper.RedisPool;
import orestes.bloomfilter.redis.helper.RedisStandalonePoolBuilder;

public class FilterBuilder
implements Cloneable,
Serializable {
    private boolean redisBacked = false;
    private boolean overwriteIfExists = false;
    private Integer expectedElements;
    private Integer size;
    private Integer hashes;
    private Integer countingBits = 16;
    private Double falsePositiveProbability;
    private String name = "";
    private String redisHost = "localhost";
    private Integer redisPort = 6379;
    private Integer redisConnections = 10;
    private boolean redisSsl = false;
    private HashProvider.HashMethod hashMethod = HashProvider.HashMethod.Murmur3KirschMitzenmacher;
    private HashProvider.HashFunction hashFunction = HashProvider.HashMethod.Murmur3KirschMitzenmacher.getHashFunction();
    private Set<Map.Entry<String, Integer>> slaves = new HashSet<Map.Entry<String, Integer>>();
    private static transient Charset defaultCharset = Charset.forName("UTF-8");
    private boolean done = false;
    private String password = null;
    private RedisPool pool;
    private int database = 0;
    private long gracePeriod = TimeUnit.HOURS.toMillis(6L);
    private long cleanupInterval = TimeUnit.HOURS.toMillis(1L);

    public FilterBuilder() {
    }

    public FilterBuilder(int expectedElements, double falsePositiveProbability) {
        this.expectedElements(expectedElements).falsePositiveProbability(falsePositiveProbability);
    }

    public FilterBuilder(int size, int hashes) {
        this.size(size).hashes(hashes);
    }

    public FilterBuilder expectedElements(int expectedElements) {
        this.expectedElements = expectedElements;
        return this;
    }

    public FilterBuilder size(int size) {
        this.size = size;
        return this;
    }

    public FilterBuilder falsePositiveProbability(double falsePositiveProbability) {
        this.falsePositiveProbability = falsePositiveProbability;
        return this;
    }

    public FilterBuilder hashes(int numberOfHashes) {
        this.hashes = numberOfHashes;
        return this;
    }

    public FilterBuilder countingBits(int countingBits) {
        this.countingBits = countingBits;
        return this;
    }

    public FilterBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FilterBuilder password(String password) {
        this.password = password;
        return this;
    }

    public FilterBuilder pool(RedisPool pool) {
        this.redisBacked(true);
        this.pool = pool;
        return this;
    }

    public FilterBuilder redisBacked(boolean redisBacked) {
        this.redisBacked = redisBacked;
        return this;
    }

    public FilterBuilder redisHost(String host) {
        this.redisBacked = true;
        this.redisHost = host;
        return this;
    }

    public FilterBuilder redisPort(int port) {
        this.redisBacked = true;
        this.redisPort = port;
        return this;
    }

    public FilterBuilder redisConnections(int numConnections) {
        this.redisBacked = true;
        this.redisConnections = numConnections;
        return this;
    }

    public FilterBuilder redisSsl(boolean ssl) {
        this.redisBacked = true;
        this.redisSsl = ssl;
        return this;
    }

    public FilterBuilder overwriteIfExists(boolean overwrite) {
        this.overwriteIfExists = overwrite;
        return this;
    }

    public FilterBuilder addReadSlave(String host, int port) {
        this.slaves.add(new AbstractMap.SimpleEntry<String, Integer>(host, port));
        return this;
    }

    public FilterBuilder hashFunction(HashProvider.HashMethod hashMethod) {
        this.hashMethod = hashMethod;
        this.hashFunction = hashMethod.getHashFunction();
        return this;
    }

    public FilterBuilder hashFunction(HashProvider.HashFunction hf) {
        this.hashFunction = hf;
        return this;
    }

    public FilterBuilder database(int database) {
        this.database = database;
        return this;
    }

    public int database() {
        return this.database;
    }

    public FilterBuilder gracePeriod(long gracePeriodInMillis) {
        this.gracePeriod = gracePeriodInMillis;
        return this;
    }

    public FilterBuilder gracePeriod(long gracePeriod, TimeUnit unit) {
        this.gracePeriod = unit.toMillis(gracePeriod);
        return this;
    }

    public long gracePeriod() {
        return this.gracePeriod;
    }

    public long gracePeriod(TimeUnit unit) {
        return unit.convert(this.gracePeriod, TimeUnit.MILLISECONDS);
    }

    public FilterBuilder cleanupInterval(long cleanupIntervalInMillis) {
        this.cleanupInterval = cleanupIntervalInMillis;
        return this;
    }

    public FilterBuilder cleanupInterval(long cleanupInterval, TimeUnit unit) {
        this.cleanupInterval = unit.toMillis(cleanupInterval);
        return this;
    }

    public long cleanupInterval() {
        return this.cleanupInterval;
    }

    public long cleanupInterval(TimeUnit unit) {
        return unit.convert(this.cleanupInterval, TimeUnit.MILLISECONDS);
    }

    public <T> BloomFilter<T> buildBloomFilter() {
        this.complete();
        if (this.redisBacked) {
            return new BloomFilterRedis(this);
        }
        return new BloomFilterMemory(this);
    }

    public <T> CountingBloomFilter<T> buildCountingBloomFilter() {
        this.complete();
        if (this.redisBacked) {
            return new CountingBloomFilterRedis(this);
        }
        if (this.countingBits == 32) {
            return new CountingBloomFilter32(this);
        }
        if (this.countingBits == 16) {
            return new CountingBloomFilter16(this);
        }
        if (this.countingBits == 8) {
            return new CountingBloomFilter8(this);
        }
        if (this.countingBits == 64) {
            return new CountingBloomFilter64(this);
        }
        return new CountingBloomFilterMemory(this);
    }

    public FilterBuilder complete() {
        if (this.done) {
            return this;
        }
        if (this.size == null && this.expectedElements != null && this.falsePositiveProbability != null) {
            this.size = FilterBuilder.optimalM(this.expectedElements.intValue(), this.falsePositiveProbability);
        }
        if (this.hashes == null && this.expectedElements != null && this.size != null) {
            this.hashes = FilterBuilder.optimalK(this.expectedElements.intValue(), this.size.intValue());
        }
        if (this.size == null || this.hashes == null) {
            throw new NullPointerException("Neither (expectedElements, falsePositiveProbability) nor (size, hashes) were specified.");
        }
        if (this.expectedElements == null) {
            this.expectedElements = FilterBuilder.optimalN(this.hashes.intValue(), this.size.intValue());
        }
        if (this.falsePositiveProbability == null) {
            this.falsePositiveProbability = FilterBuilder.optimalP(this.hashes.intValue(), this.size.intValue(), this.expectedElements.intValue());
        }
        this.done = true;
        return this;
    }

    public FilterBuilder clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cloning failed.");
        }
        return (FilterBuilder)clone;
    }

    public boolean redisBacked() {
        return this.redisBacked;
    }

    public int expectedElements() {
        return this.expectedElements;
    }

    public int size() {
        return this.size;
    }

    public int hashes() {
        return this.hashes;
    }

    public int countingBits() {
        return this.countingBits;
    }

    public double falsePositiveProbability() {
        return this.falsePositiveProbability;
    }

    public String name() {
        return this.name;
    }

    public String redisHost() {
        return this.redisHost;
    }

    public int redisPort() {
        return this.redisPort;
    }

    public int redisConnections() {
        return this.redisConnections;
    }

    public boolean redisSsl() {
        return this.redisSsl;
    }

    public HashProvider.HashMethod hashMethod() {
        return this.hashMethod;
    }

    public HashProvider.HashFunction hashFunction() {
        return this.hashFunction;
    }

    public static Charset defaultCharset() {
        return defaultCharset;
    }

    public boolean overwriteIfExists() {
        return this.overwriteIfExists;
    }

    public Set<Map.Entry<String, Integer>> getReadSlaves() {
        return this.slaves;
    }

    public boolean isCompatibleTo(FilterBuilder other) {
        return this.size() == other.size() && this.hashes() == other.hashes() && this.hashMethod() == other.hashMethod();
    }

    public static int optimalM(long n, double p) {
        return (int)Math.ceil(-1.0 * ((double)n * Math.log(p)) / Math.pow(Math.log(2.0), 2.0));
    }

    public static int optimalK(long n, long m) {
        return (int)Math.ceil(Math.log(2.0) * (double)m / (double)n);
    }

    public static int optimalN(long k, long m) {
        return (int)Math.ceil(Math.log(2.0) * (double)m / (double)k);
    }

    public static double optimalP(long k, long m, double insertedElements) {
        return Math.pow(1.0 - Math.exp((double)(-k) * insertedElements / (double)m), k);
    }

    public String password() {
        return this.password;
    }

    public RedisPool pool() {
        if (this.done && this.pool == null) {
            this.pool = ((RedisStandalonePoolBuilder)((RedisStandalonePoolBuilder)((RedisStandalonePoolBuilder)((RedisStandalonePoolBuilder)((RedisStandalonePoolBuilder)RedisPool.builder().host(this.redisHost())).port(this.redisPort())).readSlaves(this.getReadSlaves()).password(this.password())).database(this.database())).redisConnections(this.redisConnections())).build();
        }
        return this.pool;
    }
}

