/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.cachesketch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Clock;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.MigratableBloomFilter;
import orestes.bloomfilter.TimeMap;
import orestes.bloomfilter.cachesketch.ExpiringBloomFilter;
import orestes.bloomfilter.redis.CountingBloomFilterRedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public abstract class AbstractExpiringBloomFilterRedis<T>
extends CountingBloomFilterRedis<T>
implements ExpiringBloomFilter<T> {
    private final Clock clock;
    protected final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread2 = new Thread(r, "BloomFilterExpiryThreadPool");
        thread2.setDaemon(true);
        return thread2;
    });
    private final String reportReadScript = this.loadLuaScript("reportRead.lua");

    protected AbstractExpiringBloomFilterRedis(FilterBuilder builder) {
        super(builder);
        this.clock = this.pool.getClock();
        long interval = this.config.cleanupInterval();
        this.scheduler.scheduleAtFixedRate(this::cleanupTTLs, interval, interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isCached(T element) {
        Long remaining = this.getRemainingTTL(element, TimeUnit.MICROSECONDS);
        return remaining != null && remaining > 0L;
    }

    @Override
    public Long getRemainingTTL(T element, TimeUnit unit) {
        try (Jedis jedis = this.pool.getResource();){
            Double score = jedis.zscore(this.keys.TTL_KEY, element.toString());
            Long l = this.scoreToRemainingTTL(score, unit);
            return l;
        }
    }

    @Override
    public boolean isKnown(T element) {
        try (Jedis jedis = this.pool.getResource();){
            Double score = jedis.zscore(this.keys.TTL_KEY, element.toString());
            if (score == null) {
                boolean bl = false;
                return bl;
            }
            long endOfGracePeriod = this.now() - this.config.gracePeriod();
            boolean bl = score.longValue() > endOfGracePeriod;
            return bl;
        }
    }

    @Override
    public List<Boolean> isKnown(List<T> elements) {
        try (Jedis jedis = this.pool.getResource();){
            Pipeline pipe = jedis.pipelined();
            elements.forEach(it -> pipe.zscore(this.keys.TTL_KEY, it.toString()));
            List scores = pipe.syncAndReturnAll();
            long endOfGracePeriod = this.now() - this.config.gracePeriod();
            List<Boolean> list = scores.stream().map(score -> score != null && ((Double)score).longValue() > endOfGracePeriod).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Long> getRemainingTTLs(List<T> elements, TimeUnit unit) {
        try (Jedis jedis = this.pool.getResource();){
            Pipeline pipe = jedis.pipelined();
            elements.forEach(it -> pipe.zscore(this.keys.TTL_KEY, it.toString()));
            List scores = pipe.syncAndReturnAll();
            List<Long> list = scores.stream().map(score -> (Double)score).map(score -> this.scoreToRemainingTTL((Double)score, unit)).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void reportRead(T element, long TTL, TimeUnit unit) {
        try (Jedis jedis = this.pool.getResource();){
            long timestamp = this.remainingTTLToScore(TTL, unit);
            jedis.evalsha(this.reportReadScript, 1, new String[]{this.keys.TTL_KEY, String.valueOf(timestamp), element.toString()});
        }
    }

    @Override
    public Long reportWrite(T element, TimeUnit unit) {
        Long remaining = this.getRemainingTTL(element, unit);
        if (remaining == null || remaining <= 0L) {
            return null;
        }
        this.add(element);
        this.addToQueue(element, remaining, unit);
        return remaining;
    }

    @Override
    public List<Long> reportWrites(List<T> elements, TimeUnit unit) {
        List<Long> remainingTTLs = this.getRemainingTTLs(elements, TimeUnit.MICROSECONDS);
        LinkedList<T> filteredElements = new LinkedList<T>();
        LinkedList<Long> reportedTTLs = new LinkedList<Long>();
        for (int i = 0; i < remainingTTLs.size(); ++i) {
            Long remaining = remainingTTLs.get(i);
            if (remaining == null || remaining < 0L) {
                reportedTTLs.add(null);
                continue;
            }
            reportedTTLs.add(unit.convert(remaining, TimeUnit.MICROSECONDS));
            T element = elements.get(i);
            filteredElements.add(element);
            this.addToQueue(element, remaining, TimeUnit.MICROSECONDS);
        }
        this.addAll(filteredElements);
        return reportedTTLs;
    }

    @Override
    public BloomFilter<T> getClonedBloomFilter() {
        return this.toMemoryFilter();
    }

    @Override
    public void migrateFrom(BloomFilter<T> source) {
        if (!(source instanceof ExpiringBloomFilter) || !this.compatible(source)) {
            throw new MigratableBloomFilter.IncompatibleMigrationSourceException("Source is not compatible with the targeted Bloom filter");
        }
        super.migrateFrom(source);
        ExpiringBloomFilter ebfSource = (ExpiringBloomFilter)source;
        ebfSource.disableExpiration();
        CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.setTimeToLiveMap(ebfSource.getTimeToLiveMap())), CompletableFuture.runAsync(() -> this.setExpirationMap(ebfSource.getExpirationMap()))).join();
        ebfSource.enableExpiration();
    }

    @Override
    public TimeMap<T> getTimeToLiveMap() {
        try (Jedis jedis = this.pool.getResource();){
            Set tuples = jedis.zrangeByScoreWithScores(this.keys.TTL_KEY, (double)(this.now() - this.config.gracePeriod()), Double.POSITIVE_INFINITY);
            TimeMap<Object> timeMap = tuples.stream().collect(TimeMap.collectMillis(t -> t.getElement(), t -> (long)t.getScore()));
            return timeMap;
        }
    }

    @Override
    public void setTimeToLiveMap(TimeMap<T> map) {
        try (Jedis jedis = this.pool.getResource();){
            Pipeline pipeline = jedis.pipelined();
            AtomicInteger ctr = new AtomicInteger(0);
            map.forEach((item, ttl) -> {
                pipeline.zadd(this.keys.TTL_KEY, (double)ttl.longValue(), item.toString());
                if (ctr.incrementAndGet() >= 1000) {
                    ctr.set(0);
                    pipeline.sync();
                }
            });
            pipeline.sync();
        }
    }

    @Override
    public void cleanupTTLs() {
        try (Jedis jedis = this.pool.getResource();){
            jedis.zremrangeByScore(this.keys.TTL_KEY, 0.0, (double)(this.now() - this.config.gracePeriod()));
        }
    }

    protected abstract void addToQueue(T var1, long var2, TimeUnit var4);

    protected long now() {
        return this.clock.millis();
    }

    protected String loadLuaScript(String filename) {
        InputStream stream = AbstractExpiringBloomFilterRedis.class.getResourceAsStream(filename);
        String script = new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
        return this.pool.safelyReturn(jedis -> jedis.scriptLoad(script));
    }

    private long remainingTTLToScore(long TTL, TimeUnit unit) {
        return this.clock.instant().plusMillis(TimeUnit.MILLISECONDS.convert(TTL, unit)).toEpochMilli();
    }

    private Long scoreToRemainingTTL(Double score, TimeUnit unit) {
        if (score == null) {
            return null;
        }
        long sourceDuration = score.longValue() - this.now();
        long convert = unit.convert(sourceDuration, TimeUnit.MILLISECONDS);
        return convert <= 0L ? null : Long.valueOf(convert);
    }
}

