/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.memory.BloomFilterMemory;
import orestes.bloomfilter.memory.CountingBloomFilterMemory;

public class CountingBloomFilter16<T>
extends CountingBloomFilterMemory<T> {
    private short[] counters;
    private static final long MAX = 65535L;

    public CountingBloomFilter16(FilterBuilder config) {
        config.countingBits(16).complete();
        this.config = config;
        this.filter = new BloomFilterMemory(config.clone());
        this.counters = new short[config.size()];
    }

    @Override
    protected long increment(int index) {
        if (Short.toUnsignedLong(this.counters[index]) == 65535L) {
            this.overflowHandler.run();
            return 65535L;
        }
        int n = index;
        short s = (short)(this.counters[n] + 1);
        this.counters[n] = s;
        return Short.toUnsignedLong(s);
    }

    @Override
    protected long decrement(int index) {
        if (this.counters[index] == 0) {
            return 0L;
        }
        int n = index;
        short s = (short)(this.counters[n] - 1);
        this.counters[n] = s;
        return Short.toUnsignedLong(s);
    }

    @Override
    protected long count(int index) {
        return Short.toUnsignedLong(this.counters[index]);
    }

    @Override
    protected void set(int index, long newValue) {
        this.counters[index] = (short)(newValue & 0xFFFFL);
    }

    @Override
    public Map<Integer, Long> getCountMap() {
        HashMap<Integer, Long> result2 = new HashMap<Integer, Long>();
        for (int i = 0; i < this.counters.length; ++i) {
            long count = Short.toUnsignedLong(this.counters[i]);
            if (count <= 0L) continue;
            result2.put(i, count);
        }
        return result2;
    }

    @Override
    public void clear() {
        this.filter.clear();
        this.counters = new short[this.counters.length];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountingBloomFilter16)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CountingBloomFilter16 that = (CountingBloomFilter16)o;
        return Objects.equals(this.counters, that.counters);
    }
}

