/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.memory.BloomFilterMemory;
import orestes.bloomfilter.redis.RedisBitSet;
import orestes.bloomfilter.redis.helper.RedisKeys;
import orestes.bloomfilter.redis.helper.RedisPool;
import redis.clients.jedis.PipelineBase;

public class BloomFilterRedis<T>
implements BloomFilter<T> {
    private final RedisPool pool;
    private final RedisBitSet bloom;
    private final FilterBuilder config;

    public BloomFilterRedis(FilterBuilder builder) {
        FilterBuilder updateBuilder = builder.clone();
        builder.complete();
        RedisKeys keys2 = new RedisKeys(builder.name());
        this.pool = builder.pool();
        this.bloom = new RedisBitSet(this.pool, keys2.BITS_KEY, builder.size());
        this.config = keys2.persistConfig(this.pool, updateBuilder);
        if (builder.overwriteIfExists()) {
            this.clear();
        }
    }

    @Override
    public FilterBuilder config() {
        return this.config;
    }

    @Override
    public boolean addRaw(byte[] element) {
        return this.bloom.setAll(this.hash(element));
    }

    @Override
    public List<Boolean> addAll(Collection<T> elements) {
        ArrayList<Boolean> added = new ArrayList<Boolean>();
        List results = this.pool.transactionallyDo(p -> {
            for (Object value : elements) {
                for (int position : this.hash(this.toBytes(value))) {
                    this.bloom.set((PipelineBase)p, position, true);
                }
            }
        }, new String[0]);
        boolean wasAdded = false;
        int numProcessed = 0;
        for (Boolean item : results) {
            if (!item.booleanValue()) {
                wasAdded = true;
            }
            if ((numProcessed + 1) % this.config().hashes() == 0) {
                added.add(wasAdded);
                wasAdded = false;
            }
            ++numProcessed;
        }
        return added;
    }

    @Override
    public List<Boolean> contains(Collection<T> elements) {
        ArrayList<Boolean> contains = new ArrayList<Boolean>();
        List results = this.pool.transactionallyDo(p -> {
            for (Object value : elements) {
                for (int position : this.hash(this.toBytes(value))) {
                    this.bloom.get((PipelineBase)p, position);
                }
            }
        }, new String[0]);
        boolean isPresent = true;
        int numProcessed = 0;
        for (Boolean item : results) {
            if (!item.booleanValue()) {
                isPresent = false;
            }
            if ((numProcessed + 1) % this.config().hashes() == 0) {
                contains.add(isPresent);
                isPresent = true;
            }
            ++numProcessed;
        }
        return contains;
    }

    @Override
    public boolean contains(byte[] element) {
        return this.bloom.isAllSet(this.hash(element));
    }

    @Override
    public void clear() {
        this.bloom.clear();
    }

    @Override
    public void remove() {
        this.clear();
        this.pool.safelyDo(jedis -> jedis.del(this.config().name()));
        this.pool.destroy();
    }

    @Override
    public BitSet getBitSet() {
        return this.bloom.asBitSet();
    }

    public BloomFilterMemory<T> toMemoryFilter() {
        BloomFilterMemory filter = new BloomFilterMemory(this.config().clone());
        filter.setBitSet(this.getBitSet());
        return filter;
    }

    @Override
    public BloomFilter<T> clone() {
        return new BloomFilterRedis<T>(this.config.clone());
    }

    @Override
    public boolean union(BloomFilter<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersect(BloomFilter<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.bloom.isEmpty();
    }

    @Override
    public Double getEstimatedPopulation() {
        return BloomFilter.population(this.bloom, this.config());
    }

    public RedisBitSet getRedisBitSet() {
        return this.bloom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BloomFilterRedis)) {
            return false;
        }
        BloomFilterRedis that = (BloomFilterRedis)o;
        if (this.bloom != null ? !this.bloom.equals(that.bloom) : that.bloom != null) {
            return false;
        }
        return !(this.config != null ? !this.config.isCompatibleTo(that.config) : that.config != null);
    }
}

