/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.compound;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.index.Index;
import selogger.com.googlecode.cqengine.index.compound.support.CompoundAttribute;
import selogger.com.googlecode.cqengine.index.compound.support.CompoundQuery;
import selogger.com.googlecode.cqengine.index.compound.support.CompoundValueTuple;
import selogger.com.googlecode.cqengine.index.support.AbstractMapBasedAttributeIndex;
import selogger.com.googlecode.cqengine.index.support.CloseableIterable;
import selogger.com.googlecode.cqengine.index.support.Factory;
import selogger.com.googlecode.cqengine.index.support.KeyStatistics;
import selogger.com.googlecode.cqengine.index.support.KeyStatisticsAttributeIndex;
import selogger.com.googlecode.cqengine.index.support.KeyValue;
import selogger.com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import selogger.com.googlecode.cqengine.quantizer.Quantizer;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.filter.QuantizedResultSet;
import selogger.com.googlecode.cqengine.resultset.stored.StoredResultSet;
import selogger.com.googlecode.cqengine.resultset.stored.StoredSetBasedResultSet;

public class CompoundIndex<O>
extends AbstractMapBasedAttributeIndex<CompoundValueTuple<O>, O, ConcurrentMap<CompoundValueTuple<O>, StoredResultSet<O>>>
implements KeyStatisticsAttributeIndex<CompoundValueTuple<O>, O>,
OnHeapTypeIndex {
    protected static final int INDEX_RETRIEVAL_COST = 20;
    protected final CompoundAttribute<O> attribute;

    protected CompoundIndex(Factory<ConcurrentMap<CompoundValueTuple<O>, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, CompoundAttribute<O> attribute) {
        super(indexMapFactory, valueSetFactory, attribute, Collections.emptySet());
        this.attribute = attribute;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        if (query instanceof CompoundQuery) {
            CompoundQuery compoundQuery = (CompoundQuery)query;
            return this.attribute.equals(compoundQuery.getCompoundAttribute());
        }
        return false;
    }

    public CompoundAttribute<O> getAttribute() {
        return this.attribute;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(final Query<O> query, final QueryOptions queryOptions) {
        Class<?> queryClass = query.getClass();
        if (queryClass.equals(CompoundQuery.class)) {
            final CompoundQuery compoundQuery = (CompoundQuery)query;
            final CompoundValueTuple valueTuple = compoundQuery.getCompoundValueTuple();
            return new ResultSet<O>(){

                @Override
                public Iterator<O> iterator() {
                    ResultSet rs = (ResultSet)CompoundIndex.this.indexMap.get(CompoundIndex.this.getQuantizedValue(valueTuple));
                    return rs == null ? Collections.emptySet().iterator() : CompoundIndex.this.filterForQuantization(rs, compoundQuery, queryOptions).iterator();
                }

                @Override
                public boolean contains(O object) {
                    ResultSet rs = (ResultSet)CompoundIndex.this.indexMap.get(CompoundIndex.this.getQuantizedValue(valueTuple));
                    return rs != null && CompoundIndex.this.filterForQuantization(rs, compoundQuery, queryOptions).contains(object);
                }

                @Override
                public boolean matches(O object) {
                    return query.matches(object, queryOptions);
                }

                @Override
                public int size() {
                    ResultSet rs = (ResultSet)CompoundIndex.this.indexMap.get(CompoundIndex.this.getQuantizedValue(valueTuple));
                    return rs == null ? 0 : CompoundIndex.this.filterForQuantization(rs, compoundQuery, queryOptions).size();
                }

                @Override
                public int getRetrievalCost() {
                    return 20;
                }

                @Override
                public int getMergeCost() {
                    ResultSet rs = (ResultSet)CompoundIndex.this.indexMap.get(CompoundIndex.this.getQuantizedValue(valueTuple));
                    return rs == null ? 0 : rs.size();
                }

                @Override
                public void close() {
                }

                @Override
                public Query<O> getQuery() {
                    return query;
                }

                @Override
                public QueryOptions getQueryOptions() {
                    return queryOptions;
                }
            };
        }
        throw new IllegalArgumentException("Unsupported query: " + query);
    }

    @Override
    public CloseableIterable<CompoundValueTuple<O>> getDistinctKeys(QueryOptions queryOptions) {
        return super.getDistinctKeys();
    }

    @Override
    public Integer getCountForKey(CompoundValueTuple<O> key, QueryOptions queryOptions) {
        return super.getCountForKey(key);
    }

    @Override
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        return super.getCountOfDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<CompoundValueTuple<O>>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return super.getStatisticsForDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<CompoundValueTuple<O>, O>> getKeysAndValues(QueryOptions queryOptions) {
        return super.getKeysAndValues();
    }

    protected ResultSet<O> filterForQuantization(ResultSet<O> storedResultSet, Query<O> query, QueryOptions queryOptions) {
        return storedResultSet;
    }

    public static <O> CompoundIndex<O> onAttributes(Attribute<O, ?> ... attributes) {
        return CompoundIndex.onAttributes(new DefaultIndexMapFactory(), new DefaultValueSetFactory(), attributes);
    }

    public static <O> CompoundIndex<O> onAttributes(Factory<ConcurrentMap<CompoundValueTuple<O>, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, ?> ... attributes) {
        List<Attribute<O, ?>> attributeList = Arrays.asList(attributes);
        CompoundAttribute<O> compoundAttribute = new CompoundAttribute<O>(attributeList);
        return new CompoundIndex<O>(indexMapFactory, valueSetFactory, compoundAttribute);
    }

    public static <O> CompoundIndex<O> withQuantizerOnAttributes(Quantizer<CompoundValueTuple<O>> quantizer, Attribute<O, ?> ... attributes) {
        return CompoundIndex.withQuantizerOnAttributes(new DefaultIndexMapFactory(), new DefaultValueSetFactory(), quantizer, attributes);
    }

    public static <O> CompoundIndex<O> withQuantizerOnAttributes(Factory<ConcurrentMap<CompoundValueTuple<O>, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, final Quantizer<CompoundValueTuple<O>> quantizer, Attribute<O, ?> ... attributes) {
        List<Attribute<O, ?>> attributeList = Arrays.asList(attributes);
        CompoundAttribute<O> compoundAttribute = new CompoundAttribute<O>(attributeList);
        return new CompoundIndex<O>(indexMapFactory, valueSetFactory, compoundAttribute){

            @Override
            protected ResultSet<O> filterForQuantization(ResultSet<O> resultSet, Query<O> query, QueryOptions queryOptions) {
                return new QuantizedResultSet(resultSet, query, queryOptions);
            }

            @Override
            protected CompoundValueTuple<O> getQuantizedValue(CompoundValueTuple<O> attributeValue) {
                return quantizer.getQuantizedValue(attributeValue);
            }

            @Override
            public boolean isQuantized() {
                return true;
            }
        };
    }

    public static class DefaultValueSetFactory<O>
    implements Factory<StoredResultSet<O>> {
        @Override
        public StoredResultSet<O> create() {
            return new StoredSetBasedResultSet(Collections.newSetFromMap(new ConcurrentHashMap()));
        }
    }

    public static class DefaultIndexMapFactory<O>
    implements Factory<ConcurrentMap<CompoundValueTuple<O>, StoredResultSet<O>>> {
        @Override
        public ConcurrentMap<CompoundValueTuple<O>, StoredResultSet<O>> create() {
            return new ConcurrentHashMap<CompoundValueTuple<O>, StoredResultSet<O>>();
        }
    }
}

