/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.compound.support;

import java.util.ArrayList;
import java.util.List;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.index.compound.support.CompoundValueTuple;
import selogger.com.googlecode.cqengine.index.compound.support.TupleCombinationGenerator;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class CompoundAttribute<O>
implements Attribute<O, CompoundValueTuple<O>> {
    private final List<Attribute<O, ?>> attributes;

    public CompoundAttribute(List<Attribute<O, ?>> attributes) {
        if (attributes.size() < 2) {
            throw new IllegalStateException("Cannot create a compound index on fewer than two attributes: " + attributes.size());
        }
        this.attributes = attributes;
    }

    public int size() {
        return this.attributes.size();
    }

    @Override
    public Class<O> getObjectType() {
        throw new UnsupportedOperationException("Method not supported by CompoundAttribute");
    }

    @Override
    public Class<CompoundValueTuple<O>> getAttributeType() {
        throw new UnsupportedOperationException("Method not supported by CompoundAttribute");
    }

    @Override
    public String getAttributeName() {
        throw new UnsupportedOperationException("Method not supported by CompoundAttribute");
    }

    @Override
    public Iterable<CompoundValueTuple<O>> getValues(O object, QueryOptions queryOptions) {
        ArrayList attributeValueLists = new ArrayList(this.attributes.size());
        for (Attribute<O, ?> attribute : this.attributes) {
            Iterable<?> values2 = attribute.getValues(object, queryOptions);
            attributeValueLists.add(values2);
        }
        List listsOfValueCombinations = TupleCombinationGenerator.generateCombinations(attributeValueLists);
        ArrayList<CompoundValueTuple<O>> tuples = new ArrayList<CompoundValueTuple<O>>(listsOfValueCombinations.size());
        for (List valueCombination : listsOfValueCombinations) {
            tuples.add(new CompoundValueTuple(valueCombination));
        }
        return tuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompoundAttribute)) {
            return false;
        }
        CompoundAttribute that = (CompoundAttribute)o;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "CompoundAttribute{attributes=" + this.attributes + '}';
    }
}

