/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.compound.support;

import java.util.ArrayList;
import selogger.com.googlecode.cqengine.index.compound.support.CompoundAttribute;
import selogger.com.googlecode.cqengine.index.compound.support.CompoundValueTuple;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.logical.And;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.simple.Equal;
import selogger.com.googlecode.cqengine.query.simple.SimpleQuery;

public class CompoundQuery<O>
implements Query<O> {
    private final And<O> andQuery;
    private final CompoundAttribute<O> compoundAttribute;

    public CompoundQuery(And<O> andQuery, CompoundAttribute<O> compoundAttribute) {
        this.andQuery = andQuery;
        this.compoundAttribute = compoundAttribute;
    }

    @Override
    public boolean matches(O object, QueryOptions queryOptions) {
        for (SimpleQuery simpleQuery : this.andQuery.getSimpleQueries()) {
            Equal equal = (Equal)simpleQuery;
            if (equal.matches(object, queryOptions)) continue;
            return false;
        }
        return true;
    }

    public And<O> getAndQuery() {
        return this.andQuery;
    }

    public CompoundAttribute<O> getCompoundAttribute() {
        return this.compoundAttribute;
    }

    public CompoundValueTuple<O> getCompoundValueTuple() {
        ArrayList attributeValues = new ArrayList(this.andQuery.getSimpleQueries().size());
        for (SimpleQuery simpleQuery : this.andQuery.getSimpleQueries()) {
            Equal equal = (Equal)simpleQuery;
            attributeValues.add(equal.getValue());
        }
        return new CompoundValueTuple(attributeValues);
    }

    public static <O> CompoundQuery<O> fromAndQueryIfSuitable(And<O> andQuery) {
        if (andQuery.hasLogicalQueries() || andQuery.hasComparativeQueries()) {
            return null;
        }
        ArrayList attributeList = new ArrayList(andQuery.getSimpleQueries().size());
        for (SimpleQuery simpleQuery : andQuery.getSimpleQueries()) {
            if (!(simpleQuery instanceof Equal)) {
                return null;
            }
            attributeList.add(simpleQuery.getAttribute());
        }
        CompoundAttribute compoundAttribute = new CompoundAttribute(attributeList);
        return new CompoundQuery<O>(andQuery, compoundAttribute);
    }
}

