/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.hash;

import com.googlecode.concurrenttrees.common.LazyIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.index.Index;
import selogger.com.googlecode.cqengine.index.support.AbstractMapBasedAttributeIndex;
import selogger.com.googlecode.cqengine.index.support.CloseableIterable;
import selogger.com.googlecode.cqengine.index.support.Factory;
import selogger.com.googlecode.cqengine.index.support.IndexSupport;
import selogger.com.googlecode.cqengine.index.support.KeyStatistics;
import selogger.com.googlecode.cqengine.index.support.KeyStatisticsAttributeIndex;
import selogger.com.googlecode.cqengine.index.support.KeyValue;
import selogger.com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import selogger.com.googlecode.cqengine.quantizer.Quantizer;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.simple.Equal;
import selogger.com.googlecode.cqengine.query.simple.Has;
import selogger.com.googlecode.cqengine.query.simple.In;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.filter.QuantizedResultSet;
import selogger.com.googlecode.cqengine.resultset.stored.StoredResultSet;
import selogger.com.googlecode.cqengine.resultset.stored.StoredSetBasedResultSet;

public class HashIndex<A, O>
extends AbstractMapBasedAttributeIndex<A, O, ConcurrentMap<A, StoredResultSet<O>>>
implements KeyStatisticsAttributeIndex<A, O>,
OnHeapTypeIndex {
    protected static final int INDEX_RETRIEVAL_COST = 30;

    protected HashIndex(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, A> attribute) {
        super(indexMapFactory, valueSetFactory, attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(In.class);
                this.add(Has.class);
            }
        });
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        Class<?> queryClass = query.getClass();
        if (queryClass.equals(Equal.class)) {
            Equal equal = (Equal)query;
            return this.retrieveEqual(equal, queryOptions);
        }
        if (queryClass.equals(In.class)) {
            In in = (In)query;
            return this.retrieveIn(in, queryOptions);
        }
        if (queryClass.equals(Has.class)) {
            return IndexSupport.deduplicateIfNecessary(this.indexMap.values(), query, this.getAttribute(), queryOptions, 30);
        }
        throw new IllegalArgumentException("Unsupported query: " + query);
    }

    protected ResultSet<O> retrieveIn(final In<O, A> in, final QueryOptions queryOptions) {
        Iterable results = new Iterable<ResultSet<O>>(){

            @Override
            public Iterator<ResultSet<O>> iterator() {
                return new LazyIterator<ResultSet<O>>(){
                    final Iterator<A> values;
                    {
                        this.values = in.getValues().iterator();
                    }

                    @Override
                    protected ResultSet<O> computeNext() {
                        if (this.values.hasNext()) {
                            return HashIndex.this.retrieveEqual(new Equal(in.getAttribute(), this.values.next()), queryOptions);
                        }
                        return (ResultSet)this.endOfData();
                    }
                };
            }
        };
        return IndexSupport.deduplicateIfNecessary(results, in, this.getAttribute(), queryOptions, 30);
    }

    protected ResultSet<O> retrieveEqual(final Equal<O, A> equal, final QueryOptions queryOptions) {
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                ResultSet rs = (ResultSet)HashIndex.this.indexMap.get(HashIndex.this.getQuantizedValue(equal.getValue()));
                return rs == null ? Collections.emptySet().iterator() : HashIndex.this.filterForQuantization(rs, equal, queryOptions).iterator();
            }

            @Override
            public boolean contains(O object) {
                ResultSet rs = (ResultSet)HashIndex.this.indexMap.get(HashIndex.this.getQuantizedValue(equal.getValue()));
                return rs != null && HashIndex.this.filterForQuantization(rs, equal, queryOptions).contains(object);
            }

            @Override
            public boolean matches(O object) {
                return equal.matches(object, queryOptions);
            }

            @Override
            public int size() {
                ResultSet rs = (ResultSet)HashIndex.this.indexMap.get(HashIndex.this.getQuantizedValue(equal.getValue()));
                return rs == null ? 0 : HashIndex.this.filterForQuantization(rs, equal, queryOptions).size();
            }

            @Override
            public int getRetrievalCost() {
                return 30;
            }

            @Override
            public int getMergeCost() {
                ResultSet rs = (ResultSet)HashIndex.this.indexMap.get(HashIndex.this.getQuantizedValue(equal.getValue()));
                return rs == null ? 0 : rs.size();
            }

            @Override
            public void close() {
            }

            @Override
            public Query<O> getQuery() {
                return equal;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    protected ResultSet<O> filterForQuantization(ResultSet<O> storedResultSet, Query<O> query, QueryOptions queryOptions) {
        return storedResultSet;
    }

    @Override
    public Integer getCountForKey(A key, QueryOptions queryOptions) {
        return super.getCountForKey(key);
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(QueryOptions queryOptions) {
        return super.getDistinctKeys();
    }

    @Override
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        return super.getCountOfDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return super.getStatisticsForDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(QueryOptions queryOptions) {
        return super.getKeysAndValues();
    }

    public static <A, O> HashIndex<A, O> onAttribute(Attribute<O, A> attribute) {
        return HashIndex.onAttribute(new DefaultIndexMapFactory(), new DefaultValueSetFactory(), attribute);
    }

    public static <A, O> HashIndex<A, O> onSemiUniqueAttribute(Attribute<O, A> attribute) {
        return HashIndex.onAttribute(new DefaultIndexMapFactory(), new CompactValueSetFactory(), attribute);
    }

    public static <A, O> HashIndex<A, O> onAttribute(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, A> attribute) {
        return new HashIndex<A, O>(indexMapFactory, valueSetFactory, attribute);
    }

    public static <A, O> HashIndex<A, O> withQuantizerOnAttribute(Quantizer<A> quantizer, Attribute<O, A> attribute) {
        return HashIndex.withQuantizerOnAttribute(new DefaultIndexMapFactory(), new DefaultValueSetFactory(), quantizer, attribute);
    }

    public static <A, O> HashIndex<A, O> withQuantizerOnAttribute(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, final Quantizer<A> quantizer, Attribute<O, A> attribute) {
        return new HashIndex<A, O>(indexMapFactory, valueSetFactory, attribute){

            @Override
            protected ResultSet<O> filterForQuantization(ResultSet<O> resultSet, Query<O> query, QueryOptions queryOptions) {
                return new QuantizedResultSet(resultSet, query, queryOptions);
            }

            @Override
            protected A getQuantizedValue(A attributeValue) {
                return quantizer.getQuantizedValue(attributeValue);
            }

            @Override
            public boolean isQuantized() {
                return true;
            }
        };
    }

    public static class CompactValueSetFactory<O>
    implements Factory<StoredResultSet<O>> {
        @Override
        public StoredResultSet<O> create() {
            return new StoredSetBasedResultSet(Collections.newSetFromMap(new ConcurrentHashMap(1, 1.0f, 1)));
        }
    }

    public static class DefaultValueSetFactory<O>
    implements Factory<StoredResultSet<O>> {
        @Override
        public StoredResultSet<O> create() {
            return new StoredSetBasedResultSet(Collections.newSetFromMap(new ConcurrentHashMap()));
        }
    }

    public static class DefaultIndexMapFactory<A, O>
    implements Factory<ConcurrentMap<A, StoredResultSet<O>>> {
        @Override
        public ConcurrentMap<A, StoredResultSet<O>> create() {
            return new ConcurrentHashMap();
        }
    }
}

