/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.sqlite;

import java.io.Closeable;
import java.sql.Connection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import selogger.com.googlecode.cqengine.index.Index;
import selogger.com.googlecode.cqengine.index.sqlite.ConnectionManager;
import selogger.com.googlecode.cqengine.index.sqlite.SQLitePersistence;
import selogger.com.googlecode.cqengine.index.sqlite.support.DBUtils;
import selogger.com.googlecode.cqengine.persistence.Persistence;
import selogger.com.googlecode.cqengine.persistence.composite.CompositePersistence;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class RequestScopeConnectionManager
implements ConnectionManager,
Closeable {
    final Persistence<?, ?> persistence;
    final ConcurrentMap<SQLitePersistence, Connection> openConnections = new ConcurrentHashMap<SQLitePersistence, Connection>(1, 1.0f, 1);

    public RequestScopeConnectionManager(Persistence<?, ?> persistence) {
        this.persistence = persistence;
    }

    @Override
    public Connection getConnection(Index<?> index, QueryOptions queryOptions) {
        SQLitePersistence persistence = this.getPersistenceForIndex(index = index.getEffectiveIndex());
        Connection connection = (Connection)this.openConnections.get(persistence);
        if (connection == null) {
            Connection newConnection = persistence.getConnection(index, queryOptions);
            Connection existingConnection = this.openConnections.putIfAbsent(persistence, newConnection);
            if (existingConnection == null) {
                connection = newConnection;
                DBUtils.setAutoCommit(connection, false);
            } else {
                DBUtils.closeQuietly(newConnection);
                connection = existingConnection;
            }
        }
        return connection;
    }

    @Override
    public void close() {
        Iterator iterator2 = this.openConnections.values().iterator();
        while (iterator2.hasNext()) {
            Connection connection = (Connection)iterator2.next();
            DBUtils.commit(connection);
            DBUtils.closeQuietly(connection);
            iterator2.remove();
        }
    }

    SQLitePersistence getPersistenceForIndex(Index<?> index) {
        CompositePersistence compositePersistence;
        Persistence indexPersistence;
        if (this.persistence instanceof SQLitePersistence) {
            if (this.persistence.supportsIndex(index)) {
                return (SQLitePersistence)this.persistence;
            }
        } else if (this.persistence instanceof CompositePersistence && (indexPersistence = (compositePersistence = (CompositePersistence)this.persistence).getPersistenceForIndex(index)) instanceof SQLitePersistence) {
            return (SQLitePersistence)indexPersistence;
        }
        throw new IllegalStateException("No configured Persistence implementation can support the given index: " + index);
    }

    @Override
    public boolean isApplyUpdateForIndexEnabled(Index<?> index) {
        return true;
    }
}

