/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.sqlite;

import java.lang.reflect.Constructor;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.index.Index;
import selogger.com.googlecode.cqengine.index.sqlite.IdentityAttributeIndex;
import selogger.com.googlecode.cqengine.index.sqlite.SQLiteIndex;
import selogger.com.googlecode.cqengine.index.support.CloseableIterable;
import selogger.com.googlecode.cqengine.index.support.KeyStatistics;
import selogger.com.googlecode.cqengine.index.support.KeyValue;
import selogger.com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import selogger.com.googlecode.cqengine.index.support.indextype.NonHeapTypeIndex;
import selogger.com.googlecode.cqengine.persistence.support.ObjectSet;
import selogger.com.googlecode.cqengine.persistence.support.ObjectStore;
import selogger.com.googlecode.cqengine.persistence.support.serialization.PersistenceConfig;
import selogger.com.googlecode.cqengine.persistence.support.serialization.PojoSerializer;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.QueryFactory;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.ResultSet;

public class SQLiteIdentityIndex<A extends Comparable<A>, O>
implements IdentityAttributeIndex<A, O>,
SortedKeyStatisticsAttributeIndex<A, O>,
NonHeapTypeIndex {
    final SQLiteIndex<A, O, byte[]> sqLiteIndex;
    final Class<O> objectType;
    final SimpleAttribute<O, A> primaryKeyAttribute;
    final SimpleAttribute<A, O> foreignKeyAttribute;
    final PojoSerializer<O> pojoSerializer;

    public SQLiteIdentityIndex(SimpleAttribute<O, A> primaryKeyAttribute) {
        this.sqLiteIndex = new SQLiteIndex<A, O, byte[]>(primaryKeyAttribute, new SerializingAttribute(primaryKeyAttribute.getObjectType(), byte[].class), new DeserializingAttribute(byte[].class, primaryKeyAttribute.getObjectType()), ""){

            @Override
            public Index<O> getEffectiveIndex() {
                return SQLiteIdentityIndex.this.getEffectiveIndex();
            }
        };
        this.objectType = primaryKeyAttribute.getObjectType();
        this.primaryKeyAttribute = primaryKeyAttribute;
        this.foreignKeyAttribute = new ForeignKeyAttribute();
        this.pojoSerializer = SQLiteIdentityIndex.createSerializer(this.objectType);
    }

    @Override
    public SimpleAttribute<A, O> getForeignKeyAttribute() {
        return this.foreignKeyAttribute;
    }

    @Override
    public Attribute<O, A> getAttribute() {
        return this.sqLiteIndex.getAttribute();
    }

    @Override
    public boolean isMutable() {
        return this.sqLiteIndex.isMutable();
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        return this.sqLiteIndex.supportsQuery(query, queryOptions);
    }

    @Override
    public boolean isQuantized() {
        return this.sqLiteIndex.isQuantized();
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        return this.sqLiteIndex.retrieve(query, queryOptions);
    }

    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        return this.sqLiteIndex.addAll(objectSet, queryOptions);
    }

    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        return this.sqLiteIndex.removeAll(objectSet, queryOptions);
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.sqLiteIndex.clear(queryOptions);
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.sqLiteIndex.init(objectStore, queryOptions);
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
        this.sqLiteIndex.destroy(queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(QueryOptions queryOptions) {
        return this.sqLiteIndex.getDistinctKeys(queryOptions);
    }

    @Override
    public Integer getCountForKey(A key, QueryOptions queryOptions) {
        return this.sqLiteIndex.getCountForKey(key, queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.sqLiteIndex.getDistinctKeys(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(QueryOptions queryOptions) {
        return this.sqLiteIndex.getDistinctKeysDescending(queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.sqLiteIndex.getDistinctKeysDescending(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeysDescending(QueryOptions queryOptions) {
        return this.sqLiteIndex.getStatisticsForDistinctKeysDescending(queryOptions);
    }

    @Override
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        return this.sqLiteIndex.getCountOfDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return this.sqLiteIndex.getStatisticsForDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(QueryOptions queryOptions) {
        return this.sqLiteIndex.getKeysAndValues(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.sqLiteIndex.getKeysAndValues(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(QueryOptions queryOptions) {
        return this.sqLiteIndex.getKeysAndValuesDescending(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.sqLiteIndex.getKeysAndValuesDescending(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLiteIdentityIndex that = (SQLiteIdentityIndex)o;
        return this.primaryKeyAttribute.equals(that.primaryKeyAttribute);
    }

    public int hashCode() {
        int result2 = this.getClass().hashCode();
        result2 = 31 * result2 + this.primaryKeyAttribute.hashCode();
        return result2;
    }

    static <O> PojoSerializer<O> createSerializer(Class<O> objectType) {
        Class<? extends PojoSerializer> serializerClass = null;
        try {
            PersistenceConfig persistenceConfig = objectType.getAnnotation(PersistenceConfig.class);
            if (persistenceConfig == null) {
                persistenceConfig = PersistenceConfig.DEFAULT_CONFIG;
            }
            serializerClass = persistenceConfig.serializer();
            Constructor<? extends PojoSerializer> constructor = serializerClass.getConstructor(Class.class, PersistenceConfig.class);
            PojoSerializer serializerInstance = constructor.newInstance(objectType, persistenceConfig);
            return serializerInstance;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate PojoSerializer: " + serializerClass, e);
        }
    }

    public static <A extends Comparable<A>, O> SQLiteIdentityIndex<A, O> onAttribute(SimpleAttribute<O, A> primaryKeyAttribute) {
        return new SQLiteIdentityIndex<A, O>(primaryKeyAttribute);
    }

    class ForeignKeyAttribute
    extends SimpleAttribute<A, O> {
        public ForeignKeyAttribute() {
            super(SQLiteIdentityIndex.this.primaryKeyAttribute.getAttributeType(), SQLiteIdentityIndex.this.objectType, ForeignKeyAttribute.class.getSimpleName() + "_" + SQLiteIdentityIndex.this.primaryKeyAttribute.getAttributeName());
        }

        @Override
        public O getValue(A foreignKey, QueryOptions queryOptions) {
            return SQLiteIdentityIndex.this.retrieve(QueryFactory.equal(SQLiteIdentityIndex.this.primaryKeyAttribute, foreignKey), QueryFactory.noQueryOptions()).uniqueResult();
        }
    }

    class DeserializingAttribute
    extends SimpleAttribute<byte[], O> {
        public DeserializingAttribute(Class<byte[]> objectType, Class<O> attributeType) {
            super(objectType, attributeType);
        }

        @Override
        public O getValue(byte[] bytes, QueryOptions queryOptions) {
            return SQLiteIdentityIndex.this.pojoSerializer.deserialize(bytes);
        }
    }

    class SerializingAttribute
    extends SimpleAttribute<O, byte[]> {
        public SerializingAttribute(Class<O> objectType, Class<byte[]> attributeType) {
            super(objectType, attributeType);
        }

        @Override
        public byte[] getValue(O object, QueryOptions queryOptions) {
            if (object == null) {
                throw new NullPointerException("Object was null");
            }
            try {
                return SQLiteIdentityIndex.this.pojoSerializer.serialize(object);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to serialize object, object type: " + SQLiteIdentityIndex.this.objectType, e);
            }
        }
    }
}

