/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.index.sqlite.support;

import com.googlecode.concurrenttrees.common.CharSequences;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public class DBUtils {
    public static Closeable wrapAsCloseable(final ResultSet resultSet) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                DBUtils.closeQuietly(resultSet);
            }
        };
    }

    public static boolean setAutoCommit(Connection connection, boolean value) {
        try {
            boolean previousValue = connection.getAutoCommit();
            connection.setAutoCommit(value);
            return previousValue;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to set the Connection autoCommit to " + value, e);
        }
    }

    public static void commit(Connection connection) {
        try {
            connection.commit();
        }
        catch (Exception e) {
            throw new IllegalStateException("Commit failed", e);
        }
    }

    public static boolean rollback(Connection connection) {
        try {
            connection.rollback();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            Statement statement = resultSet.getStatement();
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDBTypeForClass(Class<?> valueType) {
        if (CharSequence.class.isAssignableFrom(valueType) || BigDecimal.class.isAssignableFrom(valueType)) {
            return "TEXT";
        }
        if (Long.class.isAssignableFrom(valueType) || Integer.class.isAssignableFrom(valueType) || Short.class.isAssignableFrom(valueType) || Boolean.class.isAssignableFrom(valueType) || java.util.Date.class.isAssignableFrom(valueType)) {
            return "INTEGER";
        }
        if (Float.class.isAssignableFrom(valueType) || Double.class.isAssignableFrom(valueType)) {
            return "REAL";
        }
        if (valueType == byte[].class) {
            return "BLOB";
        }
        throw new IllegalStateException("Type " + valueType + " not supported.");
    }

    public static void setValueToPreparedStatement(int index, PreparedStatement preparedStatement, Object value) throws SQLException {
        if (value instanceof java.util.Date) {
            preparedStatement.setLong(index, ((java.util.Date)value).getTime());
        } else if (value instanceof CharSequence) {
            preparedStatement.setString(index, CharSequences.toString((CharSequence)value));
        } else {
            preparedStatement.setObject(index, value);
        }
    }

    public static int setValuesToPreparedStatement(int startIndex, PreparedStatement preparedStatement, Iterable values2) throws SQLException {
        int index = startIndex;
        for (Object value : values2) {
            DBUtils.setValueToPreparedStatement(index++, preparedStatement, value);
        }
        return index;
    }

    public static <T> T getValueFromResultSet(int index, ResultSet resultSet, Class<T> type2) {
        try {
            if (Date.class.isAssignableFrom(type2)) {
                long time = resultSet.getLong(index);
                return (T)new Date(time);
            }
            if (Time.class.isAssignableFrom(type2)) {
                long time = resultSet.getLong(index);
                return (T)new Time(time);
            }
            if (Timestamp.class.isAssignableFrom(type2)) {
                long time = resultSet.getLong(index);
                return (T)new Timestamp(time);
            }
            if (java.util.Date.class.isAssignableFrom(type2)) {
                long time = resultSet.getLong(index);
                return (T)new java.util.Date(time);
            }
            if (Long.class.isAssignableFrom(type2)) {
                return (T)Long.valueOf(resultSet.getLong(index));
            }
            if (Integer.class.isAssignableFrom(type2)) {
                return (T)Integer.valueOf(resultSet.getInt(index));
            }
            if (Short.class.isAssignableFrom(type2)) {
                return (T)Short.valueOf(resultSet.getShort(index));
            }
            if (Float.class.isAssignableFrom(type2)) {
                return (T)Float.valueOf(resultSet.getFloat(index));
            }
            if (Double.class.isAssignableFrom(type2)) {
                return (T)Double.valueOf(resultSet.getDouble(index));
            }
            if (Boolean.class.isAssignableFrom(type2)) {
                return (T)Boolean.valueOf(resultSet.getBoolean(index));
            }
            if (BigDecimal.class.isAssignableFrom(type2)) {
                return (T)resultSet.getBigDecimal(index);
            }
            if (CharSequence.class.isAssignableFrom(type2)) {
                return (T)resultSet.getString(index);
            }
            if (byte[].class.isAssignableFrom(type2)) {
                return (T)resultSet.getBytes(index);
            }
            throw new IllegalStateException("Type " + type2 + " not supported.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read the value from the resultSet. Index:" + index + ", type: " + type2, e);
        }
    }

    public static String sanitizeForTableName(String input) {
        return input.replaceAll("[^A-Za-z0-9]", "");
    }
}

