/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.persistence.disk;

import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.index.Index;
import selogger.com.googlecode.cqengine.index.sqlite.ConnectionManager;
import selogger.com.googlecode.cqengine.index.sqlite.RequestScopeConnectionManager;
import selogger.com.googlecode.cqengine.index.sqlite.SQLitePersistence;
import selogger.com.googlecode.cqengine.index.sqlite.support.DBQueries;
import selogger.com.googlecode.cqengine.index.sqlite.support.DBUtils;
import selogger.com.googlecode.cqengine.index.support.indextype.DiskTypeIndex;
import selogger.com.googlecode.cqengine.persistence.support.ObjectStore;
import selogger.com.googlecode.cqengine.persistence.support.PersistenceFlags;
import selogger.com.googlecode.cqengine.persistence.support.sqlite.LockReleasingConnection;
import selogger.com.googlecode.cqengine.persistence.support.sqlite.SQLiteDiskIdentityIndex;
import selogger.com.googlecode.cqengine.persistence.support.sqlite.SQLiteObjectStore;
import selogger.com.googlecode.cqengine.query.QueryFactory;
import selogger.com.googlecode.cqengine.query.option.FlagsEnabled;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class DiskPersistence<O, A extends Comparable<A>>
implements SQLitePersistence<O, A>,
Closeable {
    final SimpleAttribute<O, A> primaryKeyAttribute;
    final File file;
    final SQLiteDataSource sqLiteDataSource;
    final boolean useReadWriteLock;
    final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    static final Properties DEFAULT_PROPERTIES = new Properties();
    volatile Connection persistentConnection;
    volatile boolean closed = false;

    protected DiskPersistence(SimpleAttribute<O, A> primaryKeyAttribute, File file, Properties overrideProperties) {
        boolean useReadWriteLock;
        Properties effectiveProperties = new Properties();
        effectiveProperties.putAll((Map<?, ?>)DEFAULT_PROPERTIES);
        effectiveProperties.putAll((Map<?, ?>)overrideProperties);
        SQLiteConfig sqLiteConfig = new SQLiteConfig(effectiveProperties);
        SQLiteDataSource sqLiteDataSource = new SQLiteDataSource(sqLiteConfig);
        sqLiteDataSource.setUrl("jdbc:sqlite:file:" + file);
        this.primaryKeyAttribute = primaryKeyAttribute;
        this.file = file.getAbsoluteFile();
        this.sqLiteDataSource = sqLiteDataSource;
        boolean openPersistentConnection = "true".equals(effectiveProperties.getProperty("persistent_connection"));
        boolean useSharedCache = "true".equals(effectiveProperties.getProperty("shared_cache"));
        boolean bl = useReadWriteLock = !"false".equals(effectiveProperties.getProperty("use_read_write_lock"));
        if (useSharedCache) {
            sqLiteDataSource.setUrl("jdbc:sqlite:file:" + file + "?cache=shared");
            this.useReadWriteLock = useReadWriteLock;
        } else {
            sqLiteDataSource.setUrl("jdbc:sqlite:file:" + file);
            this.useReadWriteLock = false;
        }
        if (useSharedCache || openPersistentConnection) {
            this.persistentConnection = this.getConnectionWithoutRWLock(null, QueryFactory.noQueryOptions());
        }
    }

    @Override
    public SimpleAttribute<O, A> getPrimaryKeyAttribute() {
        return this.primaryKeyAttribute;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Connection getConnection(Index<?> index, QueryOptions queryOptions) {
        return this.useReadWriteLock ? this.getConnectionWithRWLock(index, queryOptions) : this.getConnectionWithoutRWLock(index, queryOptions);
    }

    protected Connection getConnectionWithRWLock(Index<?> index, QueryOptions queryOptions) {
        Connection connection;
        Lock connectionLock = FlagsEnabled.isFlagEnabled(queryOptions, PersistenceFlags.READ_REQUEST) ? this.readWriteLock.readLock() : this.readWriteLock.writeLock();
        connectionLock.lock();
        try {
            connection = this.getConnectionWithoutRWLock(index, queryOptions);
        }
        catch (RuntimeException e) {
            connectionLock.unlock();
            throw e;
        }
        return LockReleasingConnection.wrap(connection, connectionLock);
    }

    protected Connection getConnectionWithoutRWLock(Index<?> index, QueryOptions queryOptions) {
        if (this.closed) {
            throw new IllegalStateException("DiskPersistence has been closed: " + this.toString());
        }
        try {
            return this.sqLiteDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to open SQLite connection for file: " + this.file, e);
        }
    }

    @Override
    public boolean supportsIndex(Index<O> index) {
        return index instanceof DiskTypeIndex;
    }

    @Override
    public void close() {
        DBUtils.closeQuietly(this.persistentConnection);
        this.persistentConnection = null;
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesUsed() {
        long l;
        Connection connection = null;
        try {
            connection = this.getConnection(null, QueryFactory.noQueryOptions());
            l = DBQueries.getDatabaseSize(connection);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(connection);
        return l;
    }

    @Override
    public void compact() {
        Connection connection = null;
        try {
            connection = this.getConnection(null, QueryFactory.noQueryOptions());
            DBQueries.compactDatabase(connection);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expand(long numBytes) {
        Connection connection = null;
        try {
            connection = this.getConnection(null, QueryFactory.noQueryOptions());
            DBQueries.expandDatabase(connection, numBytes);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(connection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiskPersistence)) {
            return false;
        }
        DiskPersistence that = (DiskPersistence)o;
        return this.primaryKeyAttribute.equals(that.primaryKeyAttribute) && this.file.equals(that.file);
    }

    public int hashCode() {
        int result2 = this.primaryKeyAttribute.hashCode();
        result2 = 31 * result2 + this.file.hashCode();
        return result2;
    }

    public String toString() {
        return "DiskPersistence{primaryKeyAttribute=" + this.primaryKeyAttribute + ", file=" + this.file + '}';
    }

    @Override
    public ObjectStore<O> createObjectStore() {
        return new SQLiteObjectStore(this);
    }

    @Override
    public SQLiteDiskIdentityIndex<A, O> createIdentityIndex() {
        return SQLiteDiskIdentityIndex.onAttribute(this.primaryKeyAttribute);
    }

    @Override
    public void openRequestScopeResources(QueryOptions queryOptions) {
        if (queryOptions.get(ConnectionManager.class) == null) {
            queryOptions.put(ConnectionManager.class, new RequestScopeConnectionManager(this));
        }
    }

    @Override
    public void closeRequestScopeResources(QueryOptions queryOptions) {
        ConnectionManager connectionManager = queryOptions.get(ConnectionManager.class);
        if (connectionManager instanceof RequestScopeConnectionManager) {
            ((RequestScopeConnectionManager)connectionManager).close();
            queryOptions.remove(ConnectionManager.class);
        }
    }

    public static File createTempFile() {
        File tempFile;
        try {
            tempFile = File.createTempFile("cqengine_", ".db");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create temp file for CQEngine disk persistence", e);
        }
        return tempFile;
    }

    public static <O, A extends Comparable<A>> DiskPersistence<O, A> onPrimaryKey(SimpleAttribute<O, A> primaryKeyAttribute) {
        return DiskPersistence.onPrimaryKeyInFile(primaryKeyAttribute, DiskPersistence.createTempFile());
    }

    public static <O, A extends Comparable<A>> DiskPersistence<O, A> onPrimaryKeyInFile(SimpleAttribute<O, A> primaryKeyAttribute, File file) {
        return DiskPersistence.onPrimaryKeyInFileWithProperties(primaryKeyAttribute, file, new Properties());
    }

    public static <O, A extends Comparable<A>> DiskPersistence<O, A> onPrimaryKeyInFileWithProperties(SimpleAttribute<O, A> primaryKeyAttribute, File file, Properties overrideProperties) {
        return new DiskPersistence<O, A>(primaryKeyAttribute, file, overrideProperties);
    }

    static {
        DEFAULT_PROPERTIES.setProperty("busy_timeout", String.valueOf(Integer.MAX_VALUE));
        DEFAULT_PROPERTIES.setProperty("journal_mode", "WAL");
        DEFAULT_PROPERTIES.setProperty("synchronous", "NORMAL");
        DEFAULT_PROPERTIES.setProperty("shared_cache", "false");
        DEFAULT_PROPERTIES.setProperty("persistent_connection", "false");
    }
}

