/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.persistence.support.sqlite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.concurrent.locks.Lock;

public class LockReleasingConnection
implements InvocationHandler {
    final Connection targetConnection;
    final Lock lockToUnlock;
    boolean unlockedAlready = false;

    LockReleasingConnection(Connection targetConnection, Lock lockToUnlock) {
        this.targetConnection = targetConnection;
        this.lockToUnlock = lockToUnlock;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args2) throws Throwable {
        Object result2 = m.invoke((Object)this.targetConnection, args2);
        if (m.getName().equals("close") && !this.unlockedAlready) {
            this.lockToUnlock.unlock();
            this.unlockedAlready = true;
        }
        return result2;
    }

    public static Connection wrap(Connection targetConnection, Lock lockToUnlock) {
        return (Connection)Proxy.newProxyInstance(targetConnection.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new LockReleasingConnection(targetConnection, lockToUnlock));
    }
}

