/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.quantizer;

import java.math.BigInteger;
import selogger.com.googlecode.cqengine.quantizer.Quantizer;

public class BigIntegerQuantizer {
    BigIntegerQuantizer() {
    }

    public static Quantizer<BigInteger> withCompressionFactor(int compressionFactor) {
        return new CompressingQuantizer(compressionFactor);
    }

    static class CompressingQuantizer
    implements Quantizer<BigInteger> {
        private final BigInteger compressionFactor;

        public CompressingQuantizer(int compressionFactor) {
            if (compressionFactor < 2) {
                throw new IllegalArgumentException("Invalid compression factor, must be >= 2: " + compressionFactor);
            }
            this.compressionFactor = BigInteger.valueOf(compressionFactor);
        }

        @Override
        public BigInteger getQuantizedValue(BigInteger attributeValue) {
            return attributeValue.divide(this.compressionFactor).multiply(this.compressionFactor);
        }
    }
}

