/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.quantizer;

import selogger.com.googlecode.cqengine.quantizer.Quantizer;

public class DoubleQuantizer {
    DoubleQuantizer() {
    }

    public static Quantizer<Double> withCompressionFactor(int compressionFactor) {
        return compressionFactor < 2 ? new TruncatingQuantizer() : new TruncatingAndCompressingQuantizer(compressionFactor);
    }

    static class TruncatingQuantizer
    implements Quantizer<Double> {
        TruncatingQuantizer() {
        }

        @Override
        public Double getQuantizedValue(Double attributeValue) {
            return (long)attributeValue.doubleValue();
        }
    }

    static class TruncatingAndCompressingQuantizer
    implements Quantizer<Double> {
        private final int compressionFactor;

        public TruncatingAndCompressingQuantizer(int compressionFactor) {
            if (compressionFactor < 2) {
                throw new IllegalArgumentException("Invalid compression factor, must be >= 2: " + compressionFactor);
            }
            this.compressionFactor = compressionFactor;
        }

        @Override
        public Double getQuantizedValue(Double attributeValue) {
            return attributeValue.longValue() / (long)this.compressionFactor * (long)this.compressionFactor;
        }
    }
}

